package com.bizvane.basic.feign.feign;

import com.bizvane.basic.feign.model.req.approve.AddOrModifyApproveConfigReqVO;
import com.bizvane.basic.feign.model.req.approve.EditApproveConfigReqVO;
import com.bizvane.basic.feign.model.req.approve.QueryApproveConfigListRequestVO;
import com.bizvane.basic.feign.model.rsp.approve.QueryApproveConfigListResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tBasicApproveConfig")
@Api(value = "审批流程配置RPC")
public interface BasicApproveConfigRpcFeign {


    @PostMapping("/pageList")
    @ApiOperation(value = "分页查询列表")
    ResponseData<PageInfo<QueryApproveConfigListResponseVO>> pageList(@RequestBody @Validated QueryApproveConfigListRequestVO request);

    @PostMapping("/addOrModify")
    @ApiOperation(value = "保存、编辑审批配置")
    ResponseData<Boolean> addOrModify(@RequestBody @Validated AddOrModifyApproveConfigReqVO request);

    @PostMapping("/detail")
    @ApiOperation(value = "详情")
    ResponseData<QueryApproveConfigListResponseVO> detail(@RequestBody @Validated EditApproveConfigReqVO request);


    @PostMapping("/delete")
    @ApiOperation(value = "删除")
    ResponseData<Boolean> delete(@RequestBody @Validated EditApproveConfigReqVO request);


    @PostMapping("/editStatus")
    @ApiOperation(value = "启用、禁用")
    ResponseData<Boolean> editStatus(@RequestBody @Validated EditApproveConfigReqVO request);

}
