package com.bizvane.basic.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 订单详细表
 * </p>
 *
 * @author zhangrenjie@zhidemai.com
 * @since 2024-11-04
 */
@Getter
@Setter
public class TStaffOrderDetailVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("订单明细code")
    private String orderDetailCode;

    @ApiModelProperty("所属订单")
    private String orderCode;

    @ApiModelProperty("订单详情编号")
    private String orderDetailNo;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("商品编号")
    private String productNo;

    @ApiModelProperty("购买数量")
    private BigDecimal quantityDecimal;

    @ApiModelProperty("吊牌价")
    private BigDecimal tagPrice;

    @ApiModelProperty("折扣价")
    private BigDecimal discountPrice;

    @ApiModelProperty("成交价（成交价 = 折扣价 = 吊牌价x折扣率）")
    private BigDecimal tradeAmountDetail;

    @ApiModelProperty("订单详情成交价总金额(trade_amount_detail*数量)")
    private BigDecimal tradeDetailTotalAmount;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private Date createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private Date modifiedDate;

    @ApiModelProperty("版本号")
    private Integer version;
}
