package com.bizvane.basic.feign.model.req.approve;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Getter
@Setter
@ApiModel
public class AuditApproveTaskRequestVO {

    @ApiModelProperty(value = "任务code", required = true)
    @NotBlank(message = "任务code不能为空")
    private String taskCode;

    @ApiModelProperty(value = "任务节点code", required = true)
    private String nodeCode;

    @NotNull(message = "审批状态不能为空")
    @ApiModelProperty(value = "审批状态（1审核中 2审核通过 3审核拒绝 4审核超时 5审核撤销）", required = true)
    private Integer status;

    @ApiModelProperty(value = "审批备注")
    private String remark;

    @ApiModelProperty(value = "审批人code")
    @NotBlank(message = "审批人不能为空")
    private String approveUserCode;

    @ApiModelProperty(value = "审批人")
    private String approveUserName;


}
