package com.bizvane.basic.feign.model.req.approve;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Getter
@Setter
@ApiModel
public class AddOrModifyApproveConfigReqVO {

    @ApiModelProperty("流程code（编辑的时候该字段必填）")
    private String approveConfigCode;

    @ApiModelProperty(value = "流程名称")
    @NotBlank(message = "审批范围不能为空")
    private String approveName;

    @ApiModelProperty(value = "审批范围")
    private String approveRange;

    @ApiModelProperty(value = "审批范围名称")
    private String approveRangeName;

    @ApiModelProperty(value = "审批范围集合")
    @Valid
    @NotEmpty(message = "审批范围集合不能为空")
    private List<ApproveRangeVO> approveRangeList;

    @ApiModelProperty(value = "审批业务")
    @NotEmpty(message = "审批业务不能为空")
    private String approveBusiness;

    @ApiModelProperty(value = "审批业务名称")
    @NotEmpty(message = "审批业务名称不能为空")
    private String approveBusinessName;

    @ApiModelProperty(value = "状态（0禁用 1启用）")
    private Integer status;

    @ApiModelProperty("创建人id")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("修改人id")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty(value = "审批配置节点")
    @Valid
    @NotEmpty(message = "审批节点不能为空")
    private List<AddOrModifyApproveConfigNodeReqVO> approveConfigNodeList;


    @Getter
    @Setter
    public static  class ApproveRangeVO{

        @ApiModelProperty(value = "审批范围",required = true)
        @NotBlank(message = "审批范围不能为空")
        private String approveRange;

        @ApiModelProperty(value = "审批范围名称")
        @NotBlank(message = "审批范围不能为空")
        private String approveRangeName;

    }
}
