package com.bizvane.basic.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 楼宇表
 */
@Getter
@Setter
public class TBasicBuildingVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "pkid")
    private Long id;

    @ApiModelProperty(value = "楼宇名称")
    private String buildingName;

    @ApiModelProperty(value = "楼宇code")
    private String buildingCode;

    @ApiModelProperty(value = "机场code")
    private String airportCode;

    @ApiModelProperty(value = "状态：0=禁用；1=启用")
    private Boolean status;

    @ApiModelProperty(value = "创建人id")
    private Long createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "创建日期")
    private Date createDate;

    @ApiModelProperty(value = "修改人id")
    private Long modifiedUserId;

    @ApiModelProperty(value = "修改人")
    private String modifiedUserName;

    @ApiModelProperty(value = "修改时间")
    private Date modifiedDate;

    @ApiModelProperty(value = "数据有效性：1=有效；0=无效")
    private Boolean valid;

    @ApiModelProperty(value = "备注")
    private String remark;


}
