package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.vo.TSysRoleAuthVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tSysRoleAuth")
@Api(value = "角色权限RPC")
public interface SysRoleAuthRpcFeign {

    @RequestMapping(value = "/getRoleAuthList", method = RequestMethod.POST)
    @ApiOperation(value = "获取角色权限列表")
    ResponseData<List<TSysRoleAuthVo>> getRoleAuthList(@RequestBody TSysRoleAuthVo req);

}
