package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.req.TBasicBusinessFormatPageReq;
import com.bizvane.basic.feign.model.vo.TBasicBusinessFormatVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tBasicBusinessFormat")
@Api(value = "业态RPC")
public interface BasicBusinessFormatRpcFeign {

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ApiOperation(value = "分页条件查询列表")
    ResponseData<PageInfo<TBasicBusinessFormatVo>> pageList(@RequestBody TBasicBusinessFormatPageReq req);

    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ApiOperation(value = "业态列表")
    ResponseData<List<TBasicBusinessFormatVo>> list(@RequestBody TBasicBusinessFormatVo req);

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "添加业态")
    ResponseData<Boolean> save(@RequestBody TBasicBusinessFormatVo req);

    @RequestMapping(value = "/modify", method = RequestMethod.POST)
    @ApiOperation(value = "编辑业态")
    ResponseData<Boolean> modify(@RequestBody TBasicBusinessFormatVo req);


}
