package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.req.TBasicBuildingPageReq;
import com.bizvane.basic.feign.model.vo.TBasicBuildingVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tBasicBuilding")
@Api(value = "楼宇RPC")
public interface BasicBuildingRpcFeign {

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ApiOperation(value = "分页条件查询楼宇列表")
    ResponseData<PageInfo<TBasicBuildingVo>> pageList(@RequestBody TBasicBuildingPageReq req);

    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ApiOperation(value = "楼宇列表")
    ResponseData<List<TBasicBuildingVo>> list(@RequestBody TBasicBuildingVo req);

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "添加楼宇")
    ResponseData<Boolean> save(@RequestBody TBasicBuildingVo req);

    @RequestMapping(value = "/modify", method = RequestMethod.POST)
    @ApiOperation(value = "修改楼宇")
    ResponseData<Boolean> modify(@RequestBody TBasicBuildingVo req);


}
