package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.req.TBasicAirlinesPageReq;
import com.bizvane.basic.feign.model.vo.TBasicAirlinesVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tBasicAirlines")
@Api(value = "航司RPC")
public interface BasicAirlinesRpcFeign {

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ApiOperation(value = "分页条件查询航司列表")
    ResponseData<PageInfo<TBasicAirlinesVo>> pageList(@RequestBody TBasicAirlinesPageReq req);

    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ApiOperation(value = "航司列表")
    ResponseData<List<TBasicAirlinesVo>> list(@RequestBody TBasicAirlinesVo req);

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "添加航司")
    ResponseData<Boolean> save(@RequestBody TBasicAirlinesVo req);

    @RequestMapping(value = "/modify", method = RequestMethod.POST)
    @ApiOperation(value = "修改航司")
    ResponseData<Boolean> modify(@RequestBody TBasicAirlinesVo req);


}
