/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.base.store.service;

import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.base.store.bean.Constant;
import com.bizvane.base.store.bean.TaskFileBean;
import com.bizvane.base.store.dao.FileTaskDao;
import com.bizvane.base.store.entity.FileTask;
import com.bizvane.base.store.service.inter.ITaskFileService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class TaskFileService
implements ITaskFileService {
    @Autowired
    private FileTaskDao fileTaskDao;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public TaskFileBean addFileTask(TaskFileBean bean) {
        FileTask task = new FileTask();
        BeanUtils.copyProperties((Object)bean, (Object)task);
        Long taskId = new Random().nextLong();
        while (this.fileTaskDao.count(taskId) > 0) {
            taskId = new Random().nextLong();
        }
        task.setCreateDate(new Date());
        task.setTaskId(taskId);
        task.setValid(Boolean.valueOf(true));
        this.redisTemplate.opsForValue().set((Object)task.getTaskId().toString(), (Object)task, 43200000L, TimeUnit.MILLISECONDS);
        this.fileTaskDao.insert((Object)task);
        bean.setFileTaskId(task.getFileTaskId());
        return bean;
    }

    public TaskFileBean update(TaskFileBean bean) {
        FileTask task = new FileTask();
        BeanUtils.copyProperties((Object)bean, (Object)task);
        this.redisTemplate.opsForValue().set((Object)task.getTaskId().toString(), (Object)task, Constant.BASE_CACHED_MILLISECOND_TIME, TimeUnit.MILLISECONDS);
        if (task.getFileStatus() == (long)Constant.INT_HUNDRED || task.getFileStatus() == (long)Constant.INT_NEGATIVE_ONE) {
            QueryWrapper query = Wrappers.query();
            query.eq((Object)"task_id", (Object)task.getTaskId());
            task.setModifiedDate(new Date());
            this.fileTaskDao.update((Object)task, (Wrapper)query);
        }
        return bean;
    }

    public IPage<TaskFileBean> page(String fileType, String taskName, String startTime, String endTime, Integer pageNo, Integer pageSize) {
        Page listResultBean = new Page();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = Wrappers.query();
        wrapper.like(StringUtils.isNotBlank((CharSequence)taskName), (Object)"st.task_name", (Object)taskName);
        wrapper.eq(StringUtils.isNotBlank((CharSequence)fileType), (Object)"st.file_type", (Object)fileType);
        wrapper.between(StringUtils.isNotBlank((CharSequence)(startTime + endTime)), (Object)"st.create_date", (Object)startTime, (Object)endTime);
        IPage result = this.fileTaskDao.page(page, wrapper);
        listResultBean.setRecords(Lists.transform((List)result.getRecords(), (Function)new /* Unavailable Anonymous Inner Class!! */));
        return listResultBean;
    }

    public static void main(String[] args) {
        System.out.println(Math.abs(UUID.randomUUID().hashCode()));
    }
}

