package com.bizvane.baison.facade.rpc;

import com.bizvane.baison.facade.base.ResponseBaisonData;
import com.bizvane.baison.facade.models.RequestOutsideModel;
import com.bizvane.baison.facade.models.request.IntegralModel;
import com.bizvane.baison.facade.models.request.MemberReqModel;
import com.bizvane.baison.facade.models.request.MemberRespModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @author kitandrew
 * @version 1.0.0
 * @ClassName MemberServiceRpc.java
 * @Description baison 会员相关rpc
 * @createTime 2020年02月05日 15:38:00
 */
@FeignClient(value = "${feign.client.scrm.name}", path = "${feign.client.scrm.path}")
public interface MemberServiceRpc {

    /**
     * basion调用CRM开卡
     * @param requestVo
     * @return
     */
    @PostMapping("/member/openCard")
    ResponseBaisonData openCard(@RequestBody @Valid RequestOutsideModel<MemberReqModel> requestVo);

    /**
     * basion查询CRM会员
     * @param requestVo
     * @return
     */
    @PostMapping("/member/queryMemberInfo")
    ResponseBaisonData<MemberRespModel> queryMemberInfo(@RequestBody @Valid RequestOutsideModel<MemberReqModel> requestVo);

    /**
     * basion调用CRM开卡
     * @param requestVo
     * @return
     */
    @PostMapping("/member/updateMemberInfo")
    ResponseBaisonData updateMemberInfo(@RequestBody @Valid RequestOutsideModel<MemberReqModel> requestVo);

    /**
     * basion调用CRM操作积分
     * @param requestVo
     * @return
     */
    @PostMapping("/member/integralChange")
    ResponseBaisonData integralChange(@RequestBody @Valid RequestOutsideModel<IntegralModel> requestVo);

}
