package com.bizvane.baison.facade.rpc;

import com.bizvane.baison.facade.base.ResponseBaisonData;
import com.bizvane.baison.facade.models.request.OrderRequestModel;
import com.bizvane.baison.facade.models.RequestOutsideModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 订单接口
 */
@FeignClient(value = "${feign.client.scrm.name}", path = "${feign.client.scrm.path}")
public interface OrderServiceRpc {

    @PostMapping("/scrm/order/insert")
    ResponseBaisonData insert(@RequestBody @Valid RequestOutsideModel<OrderRequestModel> orderRequestModel);
}
