package com.bizvane.baison.facade.models.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.databind.annotation.JsonAppend;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;

/**
 * @author kitandrew
 * @version 1.0.0
 * @ClassName CouponQueryModel.java
 * @Description TODO
 * @createTime 2020年02月19日 10:00:00
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CouponQueryReqModel {

    @NotBlank(message = "brand_code不能为空")
    @JSONField(name = "brand_code")
    private String offlineBrandCode;

    @JSONField(name = "coupon_code")
    private String couponCode;

    @JSONField(name = "vip_code")
    private String erpId;

    @JSONField(name = "shop_code")
    private String useStoreCode;

    @JSONField(name = "money")
    private Float useBusinessAmount;

    // todo
    @ApiModelProperty(name = "num" ,value = "订单数量")
    private Integer num;

    @ApiModelProperty(name = "coupon_num", value = "已使用现金券数量")
    private Integer coupon_num;

    private ArrayList<CouponInnerModel> record_detail;

}
