package com.bizvane.baisonBase.facade.service.mj;


import com.alibaba.fastjson.JSONObject;
import com.bizvane.baisonBase.facade.models.mj.MjCouponSendRequestVo;
import com.bizvane.baisonBase.facade.models.mj.MjCouponTransferRequestVo;
import com.bizvane.baisonBase.facade.models.mj.MjCouponUseRequestVo;
import com.bizvane.baisonBase.facade.models.mj.MjLabelDefRequestVo;
import com.bizvane.baisonBase.facade.models.mj.MjMbrLabelRequestVo;
import com.bizvane.baisonBase.facade.models.mj.MjQueryMemberInfoRequestVo;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.IntegralAdjustRequestVO;
import com.bizvane.connectorservice.entity.common.IntegralAdjustResponseVO;
import com.bizvane.connectorservice.entity.common.MemberLoginResponseVO;
import com.bizvane.connectorservice.entity.common.MemberOpenCardRequestVO;
import com.bizvane.connectorservice.entity.common.MemberOpenCardResponseVO;
import com.github.pagehelper.PageInfo;

public interface MjMemberNewService {

		Result<MemberLoginResponseVO> queryMemberInfo(String phone, String cardNo);

    MemberOpenCardResponseVO addAndUpdateMember(MemberOpenCardRequestVO requestVo);

    IntegralAdjustResponseVO adjustIntegral(IntegralAdjustRequestVO requestVo);

    Long getExpireIntegral(MjQueryMemberInfoRequestVo requestVo);
    
    PageInfo<JSONObject> getStaffPageNew(String startTime, String endTime, int pageNum, int pageSize);
    
    boolean addAndUpdateLabelDef(MjLabelDefRequestVo requestVo);
    
    boolean addAndUpdateMbrLabel(MjMbrLabelRequestVo requestVo);
    
    boolean couponSend(MjCouponSendRequestVo requestVo);
    
    /**
     * 优惠券核销
     * @param requestVo
     * @return
     */
    boolean couponUse(MjCouponUseRequestVo requestVo);
    
    /**
     * 优惠券转赠
     * @param requestVo
     * @return
     */
    boolean couponTransfer(MjCouponTransferRequestVo requestVo);

}
