package com.bizvane.baisonBase.facade.rpc;


import com.bizvane.baisonBase.facade.models.mj.*;
import com.bizvane.connectorservice.entity.common.*;
import com.bizvane.couponfacade.models.vo.CouponEntityAndDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.vo.IntegralRecordVo;
import com.bizvane.members.facade.vo.MemberCouponExpireRequestVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 梦洁会员接口
 * */
@FeignClient(value = "${feign.client.baison.name}", path = "${feign.client.baison.path}/mjShuyun")
public interface MjShuyunServiceRpc {

    /**
     * 查询会员
     * */
    @RequestMapping(value ="queryMemberInfo",method = RequestMethod.POST)
    ResponseData<MjShuyunMemberQueryResponseVO> queryMemberInfo(@RequestParam("brandCode") String brandCode, @RequestParam("erpId") String erpId);

    /**
     * 会员注册修改
     * */
    @RequestMapping(value ="register",method = RequestMethod.POST)
    ResponseData<MjShuyunMemberOpenCardResponseVO> register(@RequestBody MjShuyunMemberOpenCardRequestVO requestVo);

    @RequestMapping(value ="mbrUpdate",method = RequestMethod.POST)
    ResponseData<Object> mbrUpdate(@RequestBody MemberOpenCardRequestVO requestVo);

    /**
     * 会员积分调整
     * */
    @RequestMapping(value ="adjustIntegral",method = RequestMethod.POST)
    ResponseData<IntegralAdjustResponseVO> adjustIntegral(@RequestBody MjShuyunIntegralAdjustRequestVO requestVo);

    @RequestMapping(value = "listIntegralRecord", method = RequestMethod.POST)
    ResponseData<PageInfo<IntegralRecordModel>> listIntegralRecord(@RequestBody IntegralRecordVo integralRecordVo);

    @RequestMapping(value ="getShuyunMbrLevel",method = RequestMethod.POST)
    ResponseData<String> getShuyunMbrLevel(@RequestParam("brandCode") String brandCode, @RequestParam("erpId") String erpId);

    @RequestMapping(value ="getShuyunMbrIntegral",method = RequestMethod.POST)
    ResponseData<Integer> getShuyunMbrIntegral(@RequestParam("brandCode") String brandCode, @RequestParam("erpId") String erpId);

    @RequestMapping(value ="listCouponExpireMember",method = RequestMethod.POST)
    ResponseData<PageInfo<MjShuyunCouponExpireMemberResponseVO>> listCouponExpireMember(@RequestBody MemberCouponExpireRequestVo requestVO);

    @RequestMapping(value ="listCoupon",method = RequestMethod.POST)
    ResponseData<PageInfo<CouponEntityAndDefinitionVO>> listCoupon(@RequestBody CouponListByMemberCodeRequestVO vo);

    @RequestMapping(value ="sendCoupon",method = RequestMethod.POST)
    ResponseData<String> sendCoupon(@RequestBody MjShuyunCouponSendRequestVo requestVO);
}
