package com.bizvane.baisonBase.facade.models.e3.vo;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 百胜E3返回的data属性分页数据格式
 * @author huangxinliu
 * @date: 2021/1/19 14:54
 */
@Data
public class BaisonE3Data<T> {

    @ApiModelProperty("数据列表")
    private List<T> rows;

    @ApiModelProperty("分页信息")
    @JSONField(name = "page_data")
    private BaisonE3ResPageData pageData;

    @Data
    public static class BaisonE3ResPageData{

        private Integer num;

        /**
         * 总记录数
         */
        private Integer count;

        private Integer pageNum;

        private Integer countPage;

    }

}


