package com.bizvane.baisonBase.facade.rpc;


import com.bizvane.baisonBase.facade.models.mj.*;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 梦洁会员接口
 * */
@FeignClient(value = "${feign.client.baison.name}", path = "${feign.client.baison.path}/mjShuyun")
public interface MjShuyunServiceRpc {

    /**
     * 查询会员
     * */
    @RequestMapping(value ="queryMemberInfo",method = RequestMethod.POST)
    ResponseData<MjShuyunMemberQueryResponseVO> queryMemberInfo(@RequestParam("brandCode") String brandCode, @RequestParam("erpId") String erpId);

    /**
     * 会员注册修改
     * */
    @RequestMapping(value ="register",method = RequestMethod.POST)
    ResponseData<MjShuyunMemberOpenCardResponseVO> register(@RequestBody MjShuyunMemberOpenCardRequestVO requestVo);

    /**
     * 会员积分调整
     * */
    @RequestMapping(value ="adjustIntegral",method = RequestMethod.POST)
    ResponseData<IntegralAdjustResponseVO> adjustIntegral(@RequestBody MjShuyunIntegralAdjustRequestVO requestVo);

    @RequestMapping(value ="getShuyunMbrLevel",method = RequestMethod.POST)
    ResponseData<String> getShuyunMbrLevel(@RequestParam("brandCode") String brandCode, @RequestParam("erpId") String erpId);

    @RequestMapping(value ="getShuyunMbrIntegral",method = RequestMethod.POST)
    ResponseData<Integer> getShuyunMbrIntegral(@RequestParam("brandCode") String brandCode, @RequestParam("erpId") String erpId);
}
