/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.quickbi.authx.signature;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignatureUtil {
    public static String buildStringToSign(String uri, String method, Map<String, String> parameters) {
        String queryString;
        if (null == uri || "".equalsIgnoreCase(uri.trim()) || null == method || "".equalsIgnoreCase(method.trim())) {
            throw new IllegalArgumentException("input parameter error, uri or method can not be null");
        }
        uri = uri.replace("+", " ");
        StringBuilder sb = new StringBuilder();
        sb.append(method.toUpperCase());
        sb.append("\n");
        sb.append(uri);
        sb.append("\n");
        if (null != parameters && parameters.size() > 0 && null != (queryString = SignatureUtil.buildSortedString(parameters, "=", "&"))) {
            sb.append(queryString);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String sign(String stringToSign, String secretKey) {
        if (null == stringToSign || null == secretKey) {
            throw new IllegalArgumentException("input parameter error");
        }
        try {
            String encodeString = SignatureUtil.percentEncode(stringToSign);
            return SignatureUtil.sha256(encodeString, secretKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("error in encode string");
        }
    }

    private static String percentEncode(String value) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, "utf-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    private static String buildSortedString(Map<String, String> maps, String symbol1, String symbol2) {
        StringBuilder sb = new StringBuilder();
        LinkedList<String> keys = new LinkedList<String>();
        for (String key : maps.keySet()) {
            keys.add(key);
        }
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key;
            key = (String)keys.get(i);
            String value = maps.get(key);
            if (null == key || key.trim().length() == 0 || null == value || value.trim().length() == 0) continue;
            sb.append(key);
            sb.append(symbol1);
            sb.append(value);
            if (i == keys.size() - 1) continue;
            sb.append(symbol2);
        }
        return sb.toString();
    }

    public static String sha256(String content, String secret) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        Mac hamcSha256 = Mac.getInstance("HmacSHA256");
        byte[] keyBytes = secret.getBytes("UTF-8");
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, 0, keyBytes.length, "HmacSHA256");
        hamcSha256.init(secretKey);
        byte[] result = hamcSha256.doFinal(content.getBytes("UTF-8"));
        return new String(Base64.getEncoder().encode(result));
    }
}

