/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.web.controller;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import cn.bizvane.rocketmq.spring.exception.MessageSendException;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.retailadvqa_public.client.QATestAcsClient;
import com.aliyuncs.retailadvqa_public.model.v20200515.CheckAudiencesExportStatusRequest;
import com.aliyuncs.retailadvqa_public.model.v20200515.CheckAudiencesExportStatusResponse;
import com.aliyuncs.retailadvqa_public.model.v20200515.ListAudiencesResponse;
import com.bizvane.audience.common.constant.AudienceStatus;
import com.bizvane.audience.common.oss.DownloadFileUtil;
import com.bizvane.audience.common.oss.FileListUtil;
import com.bizvane.audience.common.redis.RedisKeyUtils;
import com.bizvane.audience.common.util.ResponseData;
import com.bizvane.audience.common.util.ResponseUtils;
import com.bizvane.audience.common.util.SnowflakeIdWorker;
import com.bizvane.audience.entity.audience.AudienceDownloadEntity;
import com.bizvane.audience.entity.audience.AudienceDownloadLogEntity;
import com.bizvane.audience.exception.AudienceErrorCode;
import com.bizvane.audience.exception.AudienceException;
import com.bizvane.audience.mapper.audience.AudienceDownloadLogMapper;
import com.bizvane.audience.mapper.audience.AudienceDownloadMapper;
import com.bizvane.audience.service.UploadFileService;
import com.bizvane.audience.service.audience.DownloadService;
import com.bizvane.audience.service.audience.SearchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(hidden=true, tags={"\u5fc3\u8df3\u68c0\u6d4b\u63a7\u5236\u5c42"})
@RestController
@RequestMapping(value={"/api"})
public class HealthCheckController {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckController.class);
    @Autowired
    private SearchService searchService;
    @Resource
    RocketMQTemplate mqTemplate;
    public static final Integer PAGE_NUM = 1;
    @Resource
    private AudienceDownloadMapper audienceDownloadMapper;
    @Resource
    private AudienceDownloadLogMapper audienceDownloadLogMapper;
    @Value(value="${aliyun.oss.accessId}")
    private String accessId;
    public static final String SUCCESS = "success";
    @Autowired
    private DownloadService downloadService;
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private FileListUtil fileListUtil;
    @Autowired
    private DownloadFileUtil downloadFileUtil;
    @Autowired
    private UploadFileService uploadFileService;

    @ApiOperation(value="\u5fc3\u8df3\u68c0\u6d4b", notes="\u5fc3\u8df3\u68c0\u6d4b", httpMethod="GET")
    @GetMapping(value={"/healthCheck"})
    public ResponseData healthCheck() throws Throwable {
        this.uploadFileService.uploadFile("/Users/wangqiming/Desktop/aliyun-java-sdk-retailadvqa-public-1.8.0.jar", "aliyun-java-sdk-retailadvqa-public-1.8.0.jar", "oem/maiscrm/bea3937b-1ff5-4aab-9a6a-f90514a0f584/", "null");
        ResponseData responseData = new ResponseData();
        return responseData;
    }

    @ApiOperation(value="12\u5c0f\u65f6job", notes="\u83b7\u53d6\u53d7\u4f17\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"/healthCheck1"})
    public ResponseData healthCheck1() {
        List tenantList = this.searchService.getTenantList();
        tenantList.stream().forEach(item -> {
            String tenantId = item.getTenantId();
            ListAudiencesResponse response = this.searchService.getAudienchList(tenantId, PAGE_NUM);
            Integer totalNum = Integer.valueOf(response.getData().getTotalNum());
            Integer pageSize = Integer.valueOf(response.getData().getPageSize());
            Integer totalPage = (totalNum + pageSize - 1) / pageSize;
            List contentItemList = response.getData().getContent();
            if (!contentItemList.isEmpty()) {
                for (int i = 1; i <= totalPage; ++i) {
                    contentItemList = this.searchService.getAudienchList(tenantId, Integer.valueOf(i)).getData().getContent();
                    contentItemList.parallelStream().forEach(qa -> {
                        String serialNumber = this.searchService.audienceListFlow(qa, item);
                        try {
                            log.info("send AUDIENCES_LIST_QUEUE mq message:{}", (Object)qa.toString());
                            Destination destination = new Destination();
                            destination.setTopic("qa_audiences_contentitem_export");
                            destination.setTag(item.getTenantId());
                            this.mqTemplate.send(destination, qa, serialNumber);
                        }
                        catch (MessageSendException e) {
                            throw new AudienceException("GetAudienceListJob send mq error :{}", e.getMessage());
                        }
                        catch (Exception e) {
                            throw new AudienceException(AudienceErrorCode.INSTER_LABEL_GROUP_ERROR, new Object[]{qa.toString(), item.toString()});
                        }
                    });
                }
            } else {
                log.warn("tenantId is not list to contentItemList:{}", (Object)tenantId);
            }
        });
        return null;
    }

    @ApiOperation(value="3\u5206\u949fjob", notes="\u83b7\u53d6\u53d7\u4f17\u72b6\u6001", httpMethod="GET")
    @GetMapping(value={"/healthCheck2"})
    public ResponseData healthCheck2() {
        List audienceDownloadEntities = this.audienceDownloadMapper.selectByDataStatus(AudienceStatus.DOWNLOAD_STATUS_ING);
        String tenantId = null;
        try {
            for (AudienceDownloadEntity audienceDownloadEntity : audienceDownloadEntities) {
                tenantId = audienceDownloadEntity.getTenantId();
                String audienceId = audienceDownloadEntity.getAudienceId();
                tenantId = "bea3937b-1ff5-4aab-9a6a-f90514a0f584";
                QATestAcsClient client = new QATestAcsClient();
                CheckAudiencesExportStatusRequest request = new CheckAudiencesExportStatusRequest();
                request.setAccessId(this.accessId);
                request.setAudienceId(audienceId);
                request.setTenantId(tenantId);
                CheckAudiencesExportStatusResponse response = (CheckAudiencesExportStatusResponse)client.getAcsResponse((AcsRequest)request);
                AudienceDownloadLogEntity audienceDownloadLogEntity = new AudienceDownloadLogEntity();
                audienceDownloadLogEntity.setRequestStatus(ResponseUtils.getRequestStatus((String)response.getData()));
                audienceDownloadLogEntity.setSerialNumber(audienceDownloadEntity.getSerialNumber());
                this.audienceDownloadLogMapper.updateBySerialNumberSelective(audienceDownloadLogEntity);
                if (!SUCCESS.equals(response.getData())) continue;
                audienceDownloadEntity.setDataStatus(AudienceStatus.CREATE_OK);
                this.audienceDownloadMapper.updateByDataStatus(audienceDownloadEntity);
            }
        }
        catch (ClientException e) {
            throw new AudienceException(AudienceErrorCode.GET_CHECK_AUDIENCESEXPORT_STATUS_ERROR, new Object[]{tenantId});
        }
        return null;
    }

    @ApiOperation(value="\u4e0b\u8f7djob", notes="\u4e0b\u8f7d", httpMethod="GET")
    @GetMapping(value={"/healthCheck3"})
    public ResponseData healthCheck3() {
        AudienceDownloadEntity audienceDownloadEntity = this.audienceDownloadMapper.selectByDataStatusOne(AudienceStatus.CREATE_OK);
        if (null != audienceDownloadEntity) {
            audienceDownloadEntity.setDataStatus(AudienceStatus.DOWNLOAD_ING);
            this.audienceDownloadMapper.updateByDataStatus(audienceDownloadEntity);
            String serialNumber = audienceDownloadEntity.getSerialNumber();
            AudienceDownloadLogEntity audienceDownloadLogEntity = new AudienceDownloadLogEntity();
            audienceDownloadLogEntity.setSerialNumber(audienceDownloadEntity.getSerialNumber());
            audienceDownloadLogEntity.setDownloadStatus(AudienceStatus.DOWNLOAD_STATUS_ING);
            this.audienceDownloadLogMapper.updateBySerialNumberSelective(audienceDownloadLogEntity);
            Boolean fileStatus = Boolean.TRUE;
            try {
                String filePath = audienceDownloadEntity.getDownloadPath();
                filePath = filePath.substring(filePath.lastIndexOf("oem"));
                List sums = this.fileListUtil.getFileList(filePath);
                if (sums.isEmpty()) {
                    fileStatus = Boolean.FALSE;
                    log.info("this path is not file neeed download error:{}", (Object)filePath);
                } else {
                    SnowflakeIdWorker snowflakeIdWorker = new SnowflakeIdWorker();
                    String countKey = RedisKeyUtils.key((String)"AUDIENCE:RECORD:COUNT:AUDIENCEID:{0}", (String[])new String[]{audienceDownloadEntity.getAudienceId()});
                    String conutValue = (String)this.redisTemplate.opsForValue().get((Object)countKey);
                    String version = snowflakeIdWorker.nextId();
                    String audienceKey = RedisKeyUtils.key((String)"AUDIENCE:AUDIENCEID:{0}:NUMBER:{1}:NAME:{2}:VERSION:{3}", (String[])new String[]{audienceDownloadEntity.getAudienceId(), audienceDownloadEntity.getSerialNumber(), audienceDownloadEntity.getAudienceName(), version});
                    this.redisTemplate.opsForValue().set((Object)audienceKey, (Object)conutValue);
                    audienceDownloadEntity.setVersion(Long.valueOf(version));
                    for (OSSObjectSummary ossObjectSummary : sums) {
                        if (filePath.equals(ossObjectSummary.getKey())) continue;
                        String path = this.downloadFileUtil.downloadFile(ossObjectSummary.getKey());
                        this.downloadService.analysisFile(audienceDownloadEntity, path);
                        if (!StringUtils.isNotBlank((CharSequence)path)) {
                            fileStatus = Boolean.FALSE;
                        }
                        audienceDownloadEntity.setDataStatus(AudienceStatus.DOWNLOAD_OK);
                        this.audienceDownloadMapper.updateByDataStatus(audienceDownloadEntity);
                        this.downloadFileUtil.deleteFile(path);
                    }
                }
                if (!fileStatus.booleanValue()) {
                    audienceDownloadEntity.setDataStatus(AudienceStatus.AL_ERROR);
                    this.audienceDownloadMapper.updateByDataStatus(audienceDownloadEntity);
                    audienceDownloadLogEntity.setDownloadStatus(AudienceStatus.DOWNLOAD_STATUS_ERROR);
                    this.audienceDownloadLogMapper.updateBySerialNumberSelective(audienceDownloadLogEntity);
                    throw new AudienceException("download aliyun file error serialNumber:{0} downPath:{1}", audienceDownloadLogEntity.getSerialNumber(), new Object[]{filePath});
                }
                audienceDownloadEntity.setDataStatus(AudienceStatus.ANALYSIS_ING);
                this.audienceDownloadMapper.updateByDataStatus(audienceDownloadEntity);
                audienceDownloadLogEntity.setDownloadStatus(AudienceStatus.DOWNLOAD_STATUS_OK);
                this.audienceDownloadLogMapper.updateBySerialNumberSelective(audienceDownloadLogEntity);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            log.info("GetAudienceDownloadJob is not to do something");
        }
        return null;
    }
}

