/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.audience.entity.audience.AudienceDownloadEntity;
import com.bizvane.audience.entity.audience.AudienceEntity;
import com.bizvane.audience.mapper.audience.AudienceMapper;
import javax.annotation.Resource;
import org.apache.commons.codec.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RocketMQMessageListener(topic="audiences_member_update")
public class AudienceUpdateListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(AudienceUpdateListener.class);
    @Resource
    private AudienceMapper audienceMapper;
    @Resource
    RocketMQTemplate mqTemplate;

    public void onMessage(ConsumerMessage<String> message) {
        String objStr = new String(message.getBody(), Charsets.UTF_8);
        AudienceDownloadEntity audienceDownloadEntity = (AudienceDownloadEntity)JSONObject.parseObject((String)objStr, AudienceDownloadEntity.class);
        AudienceEntity audienceEntity = new AudienceEntity();
        audienceEntity.setAudienceVersion(audienceDownloadEntity.getVersion());
        audienceEntity.setAudienceName(audienceDownloadEntity.getAudienceName());
        audienceEntity.setId(audienceDownloadEntity.getAudiencePrimaryKey());
        this.audienceMapper.updateByPrimaryKeySelective(audienceEntity);
        log.info("update audienceEntity version:{} audienceName:{} audiencePrimaryKey:{}", new Object[]{audienceDownloadEntity.getVersion(), audienceDownloadEntity.getAudienceName(), audienceDownloadEntity.getAudiencePrimaryKey()});
        Destination destination = new Destination();
        destination.setTopic("audiences_member_delete");
        this.mqTemplate.send(destination, (Object)audienceDownloadEntity);
    }
}

