/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.job.business;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.retailadvqa_public.client.QATestAcsClient;
import com.aliyuncs.retailadvqa_public.model.v20200515.RecreateTableRequest;
import com.aliyuncs.retailadvqa_public.model.v20200515.RecreateTableResponse;
import com.bizvane.audience.common.constant.OemConstants;
import com.bizvane.audience.common.util.StopWatchTime;
import com.bizvane.audience.common.util.SysResponseEnum;
import com.bizvane.audience.entity.metadata.CompanyTableMappingEntity;
import com.bizvane.audience.entity.metadata.CompanyTenantMappinEntity;
import com.bizvane.audience.entity.metadata.MetadataTableEntity;
import com.bizvane.audience.entity.metadata.MetadataUploadLogEntity;
import com.bizvane.audience.enums.GenerateStatusEnum;
import com.bizvane.audience.enums.UploadStatusEnum;
import com.bizvane.audience.mapper.metadata.CompanyTableMappingMapper;
import com.bizvane.audience.mapper.metadata.CompanyTenantMappingMapper;
import com.bizvane.audience.mapper.metadata.MetadataTableMapper;
import com.bizvane.audience.mapper.metadata.MetadataUploadLogMapper;
import com.bizvane.audience.service.UploadFileService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import java.io.File;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;

public abstract class AbstractMetaDataJob
extends IJobHandler {
    private String redisPrefix = "quickAudience-processor".concat(((Object)((Object)this)).getClass().getSimpleName());
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private MetadataTableMapper metadataTableMapper;
    @Resource
    private CompanyTableMappingMapper companyTableMappingMapper;
    @Resource
    private CompanyTenantMappingMapper companyTenantMappingMapper;
    @Resource
    private MetadataUploadLogMapper metadataUploadLogMapper;
    @Value(value="${aliyun.file.location}")
    private String location;
    @Value(value="${aliyun.oss.accessId}")
    private String accessId;
    @Value(value="${aliyun.oem.code}")
    private String oemCode;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final Integer STEP = 1000;
    private Integer limit = Integer.MAX_VALUE;
    private String oemTablePrefix = "oem_{oemCode}_";
    @Autowired
    private UploadFileService uploadFileUtil;
    private final String fileSuffix = ".txt";

    public ReturnT<String> execute(String param) {
        this.initParam(param);
        List<AbstractHandler> myAbstractHandlers = this.handlers();
        List<MetadataTableEntity> metadataTableEntityList = this.metadata();
        this.invoke(myAbstractHandlers, metadataTableEntityList);
        return new ReturnT(SysResponseEnum.SUCCESS.getCode(), "\u64cd\u4f5c\u6210\u529f");
    }

    private void invoke(List<AbstractHandler> myAbstractHandlers, List<MetadataTableEntity> metadataTableEntityList) {
        for (MetadataTableEntity entity : metadataTableEntityList) {
            for (AbstractHandler singleAbstractHandler : myAbstractHandlers) {
                if (!singleAbstractHandler.supportQaTableType(entity.getTableName()).booleanValue()) continue;
                List companyTableMappingEntityList = this.companyTableMappingMapper.selectEntityByMetaTable(entity.getId());
                for (CompanyTableMappingEntity mappingEntity : companyTableMappingEntityList) {
                    singleAbstractHandler.execute(mappingEntity.getSysCompanyId(), mappingEntity.getSysBrandId(), entity);
                }
            }
        }
    }

    private List<MetadataTableEntity> metadata() {
        List metadataTableEntityList = this.metadataTableMapper.selectEntityByTableType(this.getBusinessTypeName());
        if (CollectionUtil.isEmpty((Collection)metadataTableEntityList)) {
            throw new RuntimeException();
        }
        return metadataTableEntityList;
    }

    abstract String getBusinessTypeName();

    private String tenant(Long sysCompanyId, Long sysBrandId) {
        CompanyTenantMappinEntity tenantMappingEntity = this.companyTenantMappingMapper.selectByCompanyAndBrand(sysCompanyId, sysBrandId);
        if (tenantMappingEntity == null) {
            throw new RuntimeException("\u4f01\u4e1a\u4e0e\u79df\u6237\u6620\u5c04\u5173\u7cfb\u672a\u914d\u7f6e");
        }
        return tenantMappingEntity.getTenantId();
    }

    public static Integer getStep() {
        return STEP;
    }

    private void initParam(String params) {
        if (StrUtil.isNotEmpty((CharSequence)params)) {
            this.setLimit(Integer.valueOf(params));
        }
    }

    abstract List<AbstractHandler> handlers();

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    abstract class AbstractElasticSearchHandler<E>
    extends AbstractHandler<E> {
        AbstractElasticSearchHandler() {
        }

        @Override
        Long readInternal(Long position, List<E> data) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            this.commonBuilder(boolQueryBuilder);
            this.positionBuilder(position, boolQueryBuilder);
            return this.search(position, data, boolQueryBuilder);
        }

        protected void commonBuilder(BoolQueryBuilder boolQueryBuilder) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"sysCompanyId", (Object)this.getSysCompanyId()));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"brandId", (Object)this.getSysBrandId()));
        }

        abstract void positionBuilder(Long var1, BoolQueryBuilder var2);

        abstract Long search(Long var1, List<E> var2, BoolQueryBuilder var3);
    }

    abstract class AbstractHandler<E> {
        private Long sysCompanyId;
        private Long sysBrandId;
        private String date;
        private Long uploadRecordId;
        private String tenantId;
        private Integer time;
        private MetadataTableEntity entity;

        AbstractHandler() {
        }

        void execute(Long sysCompanyId, Long sysBrandId, MetadataTableEntity entity) {
            StopWatchTime.init((Logger)AbstractMetaDataJob.this.logger);
            StopWatchTime.start((String)"\u5f00\u59cb\u4efb\u52a1");
            this.init(sysCompanyId, sysBrandId, entity);
            while (true) {
                Long position = this.readRedisPosition();
                ArrayList data = new ArrayList();
                this.read(position, data);
                if (this.validate(position, data).booleanValue()) break;
                this.write(data);
            }
            this.finish();
            StopWatchTime.stop();
            StopWatchTime.pretty();
            StopWatchTime.destroy();
        }

        private String nowDate() {
            LocalDate today = LocalDate.now();
            return today.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }

        private void init(Long sysCompanyId, Long sysBrandId, MetadataTableEntity entity) {
            this.setSysCompanyId(sysCompanyId);
            this.setSysBrandId(sysBrandId);
            this.setDate(this.nowDate());
            this.setEntity(entity);
            this.setUploadRecordId(this.saveUploadLog());
            this.setTenantId(AbstractMetaDataJob.this.tenant(sysCompanyId, sysBrandId));
            this.time = 0;
        }

        private void finish() {
            AbstractMetaDataJob.this.logger.info("\u5199\u6587\u4ef6\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u5f00\u59cb\u4e0a\u4f20");
            try {
                this.upload();
                this.updateUploadLog(null, UploadStatusEnum.UPLOAD.getCode());
                this.createQaTable(this.entity);
            }
            catch (Throwable e) {
                AbstractMetaDataJob.this.logger.error("\u64cd\u4f5c\u963f\u91cc\u5143\u6570\u636e\u5931\u8d25", e);
                this.updateUploadLog(null, UploadStatusEnum.UPLOAD_FAIL.getCode());
            }
        }

        private void createQaTable(MetadataTableEntity entity) throws ClientException {
            QATestAcsClient client = new QATestAcsClient();
            RecreateTableRequest recreateTableRequest = new RecreateTableRequest();
            recreateTableRequest.setAccessId(AbstractMetaDataJob.this.accessId);
            recreateTableRequest.setOssPath("/" + this.ossPath());
            recreateTableRequest.setTableName(AbstractMetaDataJob.this.oemTablePrefix.replace("{oemCode}", AbstractMetaDataJob.this.oemCode) + entity.getTableName());
            recreateTableRequest.setTenantId(this.getTenantId());
            recreateTableRequest.setTableSchema(entity.getTableColumns());
            RecreateTableResponse recreateTableResponse = (RecreateTableResponse)client.getAcsResponse((AcsRequest)recreateTableRequest);
            if (!recreateTableResponse.getSuccess().booleanValue()) {
                throw new RuntimeException("\u521b\u5efa\u963f\u91cc\u5143\u6570\u636e\u8868\u5931\u8d25");
            }
        }

        private Long saveUploadLog() {
            MetadataUploadLogEntity record = new MetadataUploadLogEntity();
            record.setFileName(this.fileName());
            record.setFileDirectory(this.fileDirectory());
            record.setGenerateStatus(GenerateStatusEnum.NO_GENERATE.getCode());
            record.setUploadStatus(UploadStatusEnum.NOT_UPLOAD.getCode());
            record.setSysCompanyId(this.sysCompanyId);
            record.setSysBrandId(this.sysBrandId);
            record.setCreateDate(new Timestamp(System.currentTimeMillis()));
            AbstractMetaDataJob.this.metadataUploadLogMapper.insertSelective(record);
            return record.getId();
        }

        private void updateUploadLog(Integer generateStatus, Integer uploadStatus) {
            MetadataUploadLogEntity record = new MetadataUploadLogEntity();
            record.setGenerateStatus(generateStatus);
            record.setUploadStatus(uploadStatus);
            record.setModifiedDate(new Timestamp(System.currentTimeMillis()));
            record.setId(this.uploadRecordId);
            AbstractMetaDataJob.this.metadataUploadLogMapper.updateByPrimaryKeySelective(record);
        }

        void read(Long position, List<E> data) {
            Long newPosition = this.readInternal(position, data);
            AbstractMetaDataJob.this.stringRedisTemplate.opsForValue().set((Object)this.redisKey(this.sysCompanyId, this.sysBrandId), (Object)String.valueOf(newPosition), 1L, TimeUnit.DAYS);
        }

        Boolean validate(Long position, List<E> data) {
            if (position <= 0L || position > Integer.MAX_VALUE) {
                return true;
            }
            if (CollectionUtil.isEmpty(data)) {
                return true;
            }
            this.time = this.time + 1;
            if (this.time * STEP > AbstractMetaDataJob.this.limit) {
                AbstractMetaDataJob.this.logger.info("\u4e1a\u52a1\u9650\u5236\u6700\u591a:{}\u6761\u6570\u636e", (Object)AbstractMetaDataJob.this.limit);
                return true;
            }
            return false;
        }

        abstract Long readInternal(Long var1, List<E> var2);

        void write(List<E> data) {
            FileUtil.writeLines(data, (File)this.file(), (Charset)CharsetUtil.CHARSET_UTF_8, (boolean)true);
        }

        File file() {
            return FileUtil.touch((File)new File(this.filePath()));
        }

        private String filePath() {
            return this.fileDirectory().concat(FILE_SEPARATOR).concat(this.fileName());
        }

        private String fileDirectory() {
            return AbstractMetaDataJob.this.location.concat(FILE_SEPARATOR).concat(this.sysCompanyId.toString()).concat(FILE_SEPARATOR).concat(this.sysBrandId.toString()).concat(FILE_SEPARATOR).concat(this.getBusinessTableName()).concat(FILE_SEPARATOR).concat(this.date);
        }

        private String fileName() {
            return this.getBusinessTableName().concat("-").concat(this.nowDate()).concat(".txt");
        }

        abstract Boolean supportQaTableType(String var1);

        private Long readRedisPosition() {
            String redisValue = (String)AbstractMetaDataJob.this.stringRedisTemplate.opsForValue().get((Object)this.redisKey(this.sysCompanyId, this.sysBrandId));
            Long position = Integer.valueOf(Integer.MAX_VALUE).longValue();
            if (StrUtil.isNotEmpty((CharSequence)redisValue)) {
                position = Long.parseLong(redisValue);
            }
            AbstractMetaDataJob.this.logger.info("\u5f53\u524d\u4e1a\u52a1:{},\u65e5\u671f:{},\u4f4d\u7f6e:{}", new Object[]{this.getBusinessTableName(), this.getDate(), position});
            return position;
        }

        private String redisKey(Long sysCompanyId, Long sysBrandId) {
            return AbstractMetaDataJob.this.redisPrefix.concat(sysCompanyId.toString()).concat("-").concat(sysBrandId.toString()).concat("-").concat(this.getBusinessTableName()).concat(this.getDate());
        }

        abstract String getBusinessTableName();

        private void upload() throws Throwable {
            String fileName = this.filePath();
            AbstractMetaDataJob.this.uploadFileUtil.uploadFile(this.getTenantId(), fileName, this.getBusinessTableName() + ".txt", this.ossPath() + "/", String.valueOf(this.uploadRecordId));
        }

        private String ossPath() {
            return OemConstants.OSS_PATH.replace("{oemCode}", AbstractMetaDataJob.this.oemCode).replace("{tenantId}", this.getTenantId()).replace("{tableName}", AbstractMetaDataJob.this.oemTablePrefix.replace("{oemCode}", AbstractMetaDataJob.this.oemCode) + this.getBusinessTableName()).replace("{uploadDate}", this.date);
        }

        public void setSysCompanyId(Long sysCompanyId) {
            this.sysCompanyId = sysCompanyId;
        }

        public void setSysBrandId(Long sysBrandId) {
            this.sysBrandId = sysBrandId;
        }

        public void setUploadRecordId(Long uploadRecordId) {
            this.uploadRecordId = uploadRecordId;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getDate() {
            return this.date;
        }

        public Long getSysCompanyId() {
            return this.sysCompanyId;
        }

        public Long getSysBrandId() {
            return this.sysBrandId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public MetadataTableEntity getEntity() {
            return this.entity;
        }

        public void setEntity(MetadataTableEntity entity) {
            this.entity = entity;
        }
    }
}

