/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.audience.entity.audience.AudienceDownloadEntity;
import com.bizvane.audience.entity.audience.AudienceEntity;
import com.bizvane.audience.mapper.audience.AudienceMapper;
import javax.annotation.Resource;
import org.apache.commons.codec.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RocketMQMessageListener(topic="qa_audiences_member_code")
public class AudienceParticularsListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(AudienceParticularsListener.class);
    @Resource
    private AudienceMapper audienceMapper;
    public Integer version;
    @Resource
    RocketMQTemplate mqTemplate;

    public void onMessage(ConsumerMessage<String> message) {
        AudienceEntity audienceEntity = new AudienceEntity();
        String objStr = new String(message.getBody(), Charsets.UTF_8);
        AudienceDownloadEntity audienceDownloadEntity = (AudienceDownloadEntity)JSONObject.parseObject((String)objStr, AudienceDownloadEntity.class);
        Long version = (long)audienceDownloadEntity.getVersion();
        audienceDownloadEntity.setVersion(version);
        Destination destination = new Destination();
        Long id = this.audienceMapper.selectByMemberCodeAndAudienceId(audienceDownloadEntity.getMemberCode(), audienceDownloadEntity.getAudienceId());
        if (null != id) {
            audienceDownloadEntity.setAudiencePrimaryKey(id);
            destination.setTopic("audiences_member_update");
            this.mqTemplate.send(destination, (Object)audienceDownloadEntity);
        } else {
            audienceEntity.setSysCompanyId(audienceDownloadEntity.getSysCompanyId());
            audienceEntity.setSysBrandId(audienceDownloadEntity.getSysBrandId());
            audienceEntity.setAudienceId(audienceDownloadEntity.getAudienceId());
            audienceEntity.setAudienceVersion(version);
            audienceEntity.setAudienceName(audienceDownloadEntity.getAudienceName());
            audienceEntity.setMemberCode(audienceDownloadEntity.getMemberCode());
            this.audienceMapper.insert(audienceEntity);
            destination.setTopic("audiences_member_delete");
            this.mqTemplate.send(destination, (Object)audienceDownloadEntity);
        }
    }
}

