/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.job;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.retailadvqa_public.client.QATestAcsClient;
import com.aliyuncs.retailadvqa_public.model.v20200515.CheckAudienceExportStatusRequest;
import com.aliyuncs.retailadvqa_public.model.v20200515.CheckAudienceExportStatusResponse;
import com.bizvane.audience.common.constant.AudienceStatus;
import com.bizvane.audience.common.util.ResponseUtils;
import com.bizvane.audience.entity.audience.AudienceDownloadEntity;
import com.bizvane.audience.entity.audience.AudienceDownloadLogEntity;
import com.bizvane.audience.exception.AudienceErrorCode;
import com.bizvane.audience.exception.AudienceException;
import com.bizvane.audience.mapper.audience.AudienceDownloadLogMapper;
import com.bizvane.audience.mapper.audience.AudienceDownloadMapper;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@JobHandler(value="startGetAudienceStatus")
@Component
public class GetAudienceStatusJob
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(GetAudienceStatusJob.class);
    @Resource
    private AudienceDownloadMapper audienceDownloadMapper;
    @Resource
    private AudienceDownloadLogMapper audienceDownloadLogMapper;
    @Value(value="${aliyun.oss.accessId}")
    private String accessId;
    public static final String SUCCESS = "success";

    public ReturnT<String> execute(String s) {
        List audienceDownloadEntities = this.audienceDownloadMapper.selectByDataStatus(AudienceStatus.DOWNLOAD_STATUS_ING);
        String tenantId = null;
        try {
            for (AudienceDownloadEntity audienceDownloadEntity : audienceDownloadEntities) {
                tenantId = audienceDownloadEntity.getTenantId();
                String audienceId = audienceDownloadEntity.getAudienceId();
                QATestAcsClient client = new QATestAcsClient();
                CheckAudienceExportStatusRequest request = new CheckAudienceExportStatusRequest();
                request.setAccessId(this.accessId);
                request.setAudienceId(audienceId);
                request.setTenantId(tenantId);
                CheckAudienceExportStatusResponse response = (CheckAudienceExportStatusResponse)client.getAcsResponse((AcsRequest)request);
                AudienceDownloadLogEntity audienceDownloadLogEntity = new AudienceDownloadLogEntity();
                audienceDownloadLogEntity.setRequestStatus(ResponseUtils.getRequestStatus((String)response.getData()));
                audienceDownloadLogEntity.setSerialNumber(audienceDownloadEntity.getSerialNumber());
                this.audienceDownloadLogMapper.updateBySerialNumberSelective(audienceDownloadLogEntity);
                if (!SUCCESS.equals(response.getData())) continue;
                audienceDownloadEntity.setDataStatus(AudienceStatus.CREATE_OK);
                this.audienceDownloadMapper.updateByDataStatus(audienceDownloadEntity);
            }
        }
        catch (ClientException e) {
            throw new AudienceException(AudienceErrorCode.GET_CHECK_AUDIENCESEXPORT_STATUS_ERROR, new Object[]{tenantId});
        }
        return ReturnT.SUCCESS;
    }
}

