/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.job.business;

import cn.hutool.core.collection.CollectionUtil;
import com.bizvane.audience.bo.QaActivityBO;
import com.bizvane.audience.bo.QaActivityOrderBO;
import com.bizvane.audience.bo.QaActivityRecordBO;
import com.bizvane.audience.entity.business.MktActivityEntityExample;
import com.bizvane.audience.entity.business.MktActivityOrderEntityExample;
import com.bizvane.audience.entity.business.MktActivityRecordEntityExample;
import com.bizvane.audience.enums.TableTypeEnum;
import com.bizvane.audience.mapper.business.MktActivityEntityMapper;
import com.bizvane.audience.mapper.business.MktActivityOrderEntityMapper;
import com.bizvane.audience.mapper.business.MktActivityRecordEntityMapper;
import com.bizvane.audience.process.job.business.AbstractMetaDataJob;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="activityJob")
@Component
public class ActivityJob
extends AbstractMetaDataJob {
    private static final String QA_ACTIVITY = "qa_t_mkt_activity";
    private static final String QA_ACTIVITY_ORDER = "qa_t_mkt_activity_order";
    private static final String QA_ACTIVITY_RECORD = "qa_t_mkt_activity_record";
    @Autowired
    private MktActivityEntityMapper mktActivityEntityMapper;
    @Autowired
    private MktActivityOrderEntityMapper mktActivityOrderEntityMapper;
    @Autowired
    private MktActivityRecordEntityMapper mktActivityRecordEntityMapper;

    @Override
    String getBusinessTypeName() {
        return TableTypeEnum.ACTIVITY.name();
    }

    @Override
    List<AbstractMetaDataJob.AbstractHandler> handlers() {
        return Arrays.asList(new ActivityHandler(), new ActivityOrderHandler(), new ActivityRecordHandler());
    }

    class ActivityRecordHandler
    extends AbstractMetaDataJob.AbstractHandler<QaActivityRecordBO> {
        ActivityRecordHandler() {
        }

        @Override
        Long readInternal(Long position, List<QaActivityRecordBO> data) {
            MktActivityRecordEntityExample example = new MktActivityRecordEntityExample();
            example.createCriteria().andSysCompanyIdEqualTo(this.getSysCompanyId()).andSysBrandIdEqualTo(this.getSysBrandId()).andValidEqualTo(Boolean.valueOf(true)).andMktActivityRecordIdLessThan(position);
            example.setOrderByClause(" mkt_activity_record_id desc limit  ".concat(AbstractMetaDataJob.getStep().toString()));
            List entityList = ActivityJob.this.mktActivityRecordEntityMapper.selectByExample(example);
            if (CollectionUtil.isNotEmpty((Collection)entityList)) {
                List qaActivityRecordBos = entityList.stream().map(entity -> {
                    QaActivityRecordBO qaActivityRecordBo = new QaActivityRecordBO();
                    BeanUtils.copyProperties((Object)entity, (Object)qaActivityRecordBo);
                    return qaActivityRecordBo;
                }).collect(Collectors.toList());
                data.addAll(qaActivityRecordBos);
                return data.get(data.size() - 1).getMktActivityRecordId();
            }
            return position;
        }

        @Override
        Boolean supportQaTableType(String qaTableType) {
            if (ActivityJob.QA_ACTIVITY_RECORD.equals(qaTableType)) {
                return true;
            }
            return false;
        }

        @Override
        String getBusinessTableName() {
            return ActivityJob.QA_ACTIVITY_RECORD;
        }
    }

    class ActivityOrderHandler
    extends AbstractMetaDataJob.AbstractHandler<QaActivityOrderBO> {
        ActivityOrderHandler() {
        }

        @Override
        Long readInternal(Long position, List<QaActivityOrderBO> data) {
            MktActivityOrderEntityExample example = new MktActivityOrderEntityExample();
            example.createCriteria().andSysCompanyIdEqualTo(this.getSysCompanyId()).andValidEqualTo(Boolean.valueOf(true)).andMktActivityOrderIdLessThan(position);
            example.setOrderByClause(" mkt_activity_order_id desc limit  ".concat(AbstractMetaDataJob.getStep().toString()));
            List entityList = ActivityJob.this.mktActivityOrderEntityMapper.selectByExampleWithBlobs(example);
            if (CollectionUtil.isNotEmpty((Collection)entityList)) {
                List qaActivityBos = entityList.stream().map(entity -> {
                    QaActivityOrderBO qaActivityOrderBo = new QaActivityOrderBO();
                    BeanUtils.copyProperties((Object)entity, (Object)qaActivityOrderBo);
                    return qaActivityOrderBo;
                }).collect(Collectors.toList());
                data.addAll(qaActivityBos);
                return data.get(data.size() - 1).getMktActivityOrderId();
            }
            return position;
        }

        @Override
        Boolean supportQaTableType(String qaTableType) {
            if (ActivityJob.QA_ACTIVITY_ORDER.equals(qaTableType)) {
                return true;
            }
            return false;
        }

        @Override
        String getBusinessTableName() {
            return ActivityJob.QA_ACTIVITY_ORDER;
        }
    }

    class ActivityHandler
    extends AbstractMetaDataJob.AbstractHandler<QaActivityBO> {
        ActivityHandler() {
        }

        @Override
        Long readInternal(Long position, List<QaActivityBO> data) {
            MktActivityEntityExample example = new MktActivityEntityExample();
            example.createCriteria().andSysCompanyIdEqualTo(this.getSysCompanyId()).andSysBrandIdEqualTo(this.getSysBrandId()).andValidEqualTo(Boolean.valueOf(true)).andMktActivityIdLessThan(position);
            example.setOrderByClause(" mkt_activity_id desc limit  ".concat(AbstractMetaDataJob.getStep().toString()));
            List entityList = ActivityJob.this.mktActivityEntityMapper.selectByExampleWithBlobs(example);
            if (CollectionUtil.isNotEmpty((Collection)entityList)) {
                List qaActivityBos = entityList.stream().map(entity -> {
                    QaActivityBO qaActivityBo = new QaActivityBO();
                    BeanUtils.copyProperties((Object)entity, (Object)qaActivityBo);
                    return qaActivityBo;
                }).collect(Collectors.toList());
                data.addAll(qaActivityBos);
                return data.get(data.size() - 1).getMktActivityId();
            }
            return position;
        }

        @Override
        Boolean supportQaTableType(String qaTableType) {
            if (ActivityJob.QA_ACTIVITY.equals(qaTableType)) {
                return true;
            }
            return false;
        }

        @Override
        String getBusinessTableName() {
            return ActivityJob.QA_ACTIVITY;
        }
    }
}

