/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.job;

import com.aliyun.oss.model.OSSObjectSummary;
import com.bizvane.audience.common.constant.AudienceStatus;
import com.bizvane.audience.common.oss.DownloadFileUtil;
import com.bizvane.audience.common.oss.FileListUtil;
import com.bizvane.audience.common.redis.RedisKeyUtils;
import com.bizvane.audience.common.util.SnowflakeIdWorker;
import com.bizvane.audience.entity.audience.AudienceDownloadEntity;
import com.bizvane.audience.entity.audience.AudienceDownloadLogEntity;
import com.bizvane.audience.exception.AudienceException;
import com.bizvane.audience.mapper.audience.AudienceDownloadLogMapper;
import com.bizvane.audience.mapper.audience.AudienceDownloadMapper;
import com.bizvane.audience.service.audience.DownloadService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@JobHandler(value="startGetAudienceDownload")
@Component
public class GetAudienceDownloadJob
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(GetAudienceDownloadJob.class);
    @Resource
    private AudienceDownloadMapper audienceDownloadMapper;
    @Autowired
    private DownloadService downloadService;
    @Resource
    private AudienceDownloadLogMapper audienceDownloadLogMapper;
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private FileListUtil fileListUtil;
    @Autowired
    private DownloadFileUtil downloadFileUtil;

    public ReturnT<String> execute(String param) {
        AudienceDownloadEntity audienceDownloadEntity = this.audienceDownloadMapper.selectByDataStatusOne(AudienceStatus.CREATE_OK);
        if (null != audienceDownloadEntity) {
            audienceDownloadEntity.setDataStatus(AudienceStatus.DOWNLOAD_ING);
            this.audienceDownloadMapper.updateByDataStatus(audienceDownloadEntity);
            String serialNumber = audienceDownloadEntity.getSerialNumber();
            AudienceDownloadLogEntity audienceDownloadLogEntity = new AudienceDownloadLogEntity();
            audienceDownloadLogEntity.setSerialNumber(audienceDownloadEntity.getSerialNumber());
            audienceDownloadLogEntity.setDownloadStatus(AudienceStatus.DOWNLOAD_STATUS_ING);
            this.audienceDownloadLogMapper.updateBySerialNumberSelective(audienceDownloadLogEntity);
            Boolean fileStatus = Boolean.TRUE;
            try {
                String filePath = audienceDownloadEntity.getDownloadPath();
                filePath = filePath.substring(filePath.lastIndexOf("oem"));
                List sums = this.fileListUtil.getFileList(filePath);
                if (sums.isEmpty()) {
                    fileStatus = Boolean.FALSE;
                    log.info("this path is not file neeed download error:{}", (Object)filePath);
                } else {
                    SnowflakeIdWorker snowflakeIdWorker = new SnowflakeIdWorker();
                    String countKey = RedisKeyUtils.key((String)"AUDIENCE:RECORD:COUNT:AUDIENCEID:{0}", (String[])new String[]{audienceDownloadEntity.getAudienceId()});
                    String conutValue = (String)this.redisTemplate.opsForValue().get((Object)countKey);
                    String version = snowflakeIdWorker.nextId();
                    String audienceKey = RedisKeyUtils.key((String)"AUDIENCE:AUDIENCEID:{0}:NUMBER:{1}:NAME:{2}:VERSION:{3}", (String[])new String[]{audienceDownloadEntity.getAudienceId(), audienceDownloadEntity.getSerialNumber(), audienceDownloadEntity.getAudienceName(), version});
                    this.redisTemplate.opsForValue().set((Object)audienceKey, (Object)conutValue);
                    audienceDownloadEntity.setVersion(Long.valueOf(version));
                    for (OSSObjectSummary ossObjectSummary : sums) {
                        if (filePath.equals(ossObjectSummary.getKey())) continue;
                        String path = this.downloadFileUtil.downloadFile(ossObjectSummary.getKey());
                        this.downloadService.analysisFile(audienceDownloadEntity, path);
                        if (!StringUtils.isNotBlank((CharSequence)path)) {
                            fileStatus = Boolean.FALSE;
                        }
                        audienceDownloadEntity.setDataStatus(AudienceStatus.DOWNLOAD_OK);
                        this.audienceDownloadMapper.updateByDataStatus(audienceDownloadEntity);
                        this.downloadFileUtil.deleteFile(path);
                    }
                }
                if (!fileStatus.booleanValue()) {
                    audienceDownloadEntity.setDataStatus(AudienceStatus.AL_ERROR);
                    this.audienceDownloadMapper.updateByDataStatus(audienceDownloadEntity);
                    audienceDownloadLogEntity.setDownloadStatus(AudienceStatus.DOWNLOAD_STATUS_ERROR);
                    this.audienceDownloadLogMapper.updateBySerialNumberSelective(audienceDownloadLogEntity);
                    throw new AudienceException("download aliyun file error serialNumber:{0} downPath:{1}", audienceDownloadLogEntity.getSerialNumber(), new Object[]{filePath});
                }
                audienceDownloadEntity.setDataStatus(AudienceStatus.ANALYSIS_ING);
                this.audienceDownloadMapper.updateByDataStatus(audienceDownloadEntity);
                audienceDownloadLogEntity.setDownloadStatus(AudienceStatus.DOWNLOAD_STATUS_OK);
                this.audienceDownloadLogMapper.updateBySerialNumberSelective(audienceDownloadLogEntity);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            log.info("GetAudienceDownloadJob is not to do something");
        }
        return ReturnT.SUCCESS;
    }
}

