/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.audience.bo.AudienceLabelBO;
import com.bizvane.audience.common.constant.AudienceStatus;
import com.bizvane.audience.entity.audience.AudienceEntity;
import com.bizvane.audience.exception.AudienceException;
import com.bizvane.audience.service.audience.AudienceLabelService;
import com.bizvane.audience.service.audience.AudienceService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="audiences_member_summary")
public class AudienceMemberListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(AudienceMemberListener.class);
    @Autowired
    private AudienceService audienceService;
    @Autowired
    private AudienceLabelService audienceLabelService;

    public void onMessage(ConsumerMessage<String> consumerMessage) {
        String body = (String)consumerMessage.getMessage();
        log.info("AudienceMemberListener start param:{}", (Object)body);
        try {
            this.tranAudienceLabel(body);
        }
        catch (Exception e) {
            log.info("AudienceMemberListener \u5f02\u5e38\u4fe1\u606f:{} \u5f02\u5e38\u5806\u6808:{}", (Object)e.getMessage(), (Object)e);
            throw new AudienceException("AudienceMemberListener processing business Exception");
        }
        log.info("AudienceMemberListener consume success");
    }

    private void tranAudienceLabel(String value) {
        AudienceEntity audienceEntity = (AudienceEntity)JSONObject.parseObject((String)value, AudienceEntity.class);
        log.info("=========\u5206\u5305\u6570\u636ejsonObject\u5904\u7406start==========" + JSONObject.toJSONString((Object)audienceEntity));
        String audienceId = audienceEntity.getAudienceId();
        Integer count = Integer.parseInt(String.valueOf(this.audienceService.getAudienceCount(audienceId)));
        if (count > 0) {
            Integer totalPage = (count + AudienceStatus.AUDI_PAGE_SIZE - 1) / AudienceStatus.AUDI_PAGE_SIZE;
            for (int i = AudienceStatus.AUDI_PAGE_NUM.intValue(); i <= totalPage; ++i) {
                Integer limit = (i - 1) * AudienceStatus.AUDI_PAGE_SIZE;
                List audienceList = this.audienceService.getAudienceList(audienceId, limit, AudienceStatus.AUDI_PAGE_SIZE);
                if (!audienceList.isEmpty()) {
                    audienceList.parallelStream().forEach(aud -> {
                        AudienceLabelBO audienceLabelBO = new AudienceLabelBO();
                        audienceLabelBO.setMemberCode(aud.getMemberCode());
                        audienceLabelBO.setAudienceName(aud.getAudienceName());
                        boolean updateFlag = this.audienceLabelService.updateInfoByMemberCode(audienceLabelBO);
                        if (!updateFlag) {
                            this.audienceLabelService.insertSelective(audienceLabelBO);
                            log.info("audience_label\u6807\u7b7e\u6c47\u603b\u8868\u63d2\u5165\u8bb0\u5f55\u6210\u529f \u5bf9\u5e94\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)audienceLabelBO));
                        }
                    });
                    continue;
                }
                log.info("audienceId is not list to audienceList:{}", (Object)audienceId);
            }
            log.info("=========\u5206\u5305\u6570\u636ejsonObject\u5904\u7406end==========" + JSONObject.toJSONString((Object)audienceEntity));
        } else {
            log.info("query t_qa_audience count data is null\uff01");
        }
    }
}

