/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.audience.common.constant.AudienceStatus;
import com.bizvane.audience.common.constant.Separator;
import com.bizvane.audience.common.redis.RedisKeyUtils;
import com.bizvane.audience.common.redis.RedisLock;
import com.bizvane.audience.entity.audience.AudienceDownloadEntity;
import com.bizvane.audience.entity.audience.AudienceDownloadLogEntity;
import com.bizvane.audience.entity.audience.AudienceEntity;
import com.bizvane.audience.mapper.audience.AudienceDownloadLogMapper;
import com.bizvane.audience.mapper.audience.AudienceDownloadMapper;
import com.bizvane.audience.mapper.audience.AudienceMapper;
import javax.annotation.Resource;
import org.apache.commons.codec.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

@RocketMQMessageListener(topic="audiences_member_delete")
public class AudienceDeleteListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(AudienceDeleteListener.class);
    @Resource
    private AudienceMapper audienceMapper;
    @Resource
    private AudienceDownloadMapper audienceDownloadMapper;
    @Resource
    private AudienceDownloadLogMapper audienceDownloadLogMapper;
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    public static final Integer SIZE = 500;
    public static final Integer SLEEP_TIME = 500;
    @Resource
    RocketMQTemplate mqTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ConsumerMessage<String> message) {
        String objStr = new String(message.getBody(), Charsets.UTF_8);
        AudienceDownloadEntity audienceDownloadEntity = (AudienceDownloadEntity)JSONObject.parseObject((String)objStr, AudienceDownloadEntity.class);
        String key = RedisKeyUtils.key((String)"AUDIENCE:AUDIENCEID:{0}:NUMBER:{1}:NAME:{2}:VERSION:{3}", (String[])new String[]{audienceDownloadEntity.getAudienceId(), audienceDownloadEntity.getSerialNumber(), audienceDownloadEntity.getAudienceName(), audienceDownloadEntity.getVersion().toString()});
        RedisLock redisLock = new RedisLock(this.redisTemplate, key);
        try {
            boolean isGetLock = redisLock.lockRetry();
            Integer value = Separator.ONE;
            while (!isGetLock) {
                Thread.sleep(SLEEP_TIME.intValue());
            }
            if (this.redisTemplate.hasKey((Object)key).booleanValue()) {
                value = Integer.valueOf((String)this.redisTemplate.opsForValue().get((Object)key));
                value = value - 1;
                this.redisTemplate.opsForValue().set((Object)key, (Object)value.toString());
            } else {
                log.info("redis is not key where erialNumber:{} FileName:{}", (Object)audienceDownloadEntity.getSerialNumber(), (Object)audienceDownloadEntity.getAudienceName());
            }
            if (value % SIZE == Separator.ZERO) {
                this.audienceMapper.deleteByPrimaryKey(audienceDownloadEntity.getVersion(), audienceDownloadEntity.getAudienceId());
            }
            if (value <= 0) {
                this.audienceMapper.deleteByVersionAndAudienceId(audienceDownloadEntity.getVersion(), audienceDownloadEntity.getAudienceId());
                this.redisTemplate.delete((Object)key);
                Destination destination = new Destination();
                destination.setTopic("audiences_member_summary");
                AudienceEntity audienceEntity = new AudienceEntity();
                audienceEntity.setAudienceId(audienceDownloadEntity.getAudienceId());
                this.mqTemplate.send(destination, (Object)audienceEntity);
                audienceDownloadEntity.setDataStatus(AudienceStatus.ANALYSIS_OK);
                this.audienceDownloadMapper.updateBySerialNumberSelective(audienceDownloadEntity);
                AudienceDownloadLogEntity audienceDownloadLogEntity = new AudienceDownloadLogEntity();
                audienceDownloadLogEntity.setConsumeCount(Integer.valueOf(0));
                audienceDownloadLogEntity.setSerialNumber(audienceDownloadEntity.getSerialNumber());
                this.audienceDownloadLogMapper.updateBySerialNumberSelective(audienceDownloadLogEntity);
                this.audienceMapper.deleteByPrimaryKey(audienceDownloadEntity.getVersion(), audienceDownloadEntity.getAudienceId());
                log.info("redis value is zero SerialNumber:{} FileName:{} AudienceVersion:{}", new Object[]{audienceDownloadEntity.getSerialNumber(), audienceDownloadEntity.getAudienceName(), audienceEntity.getAudienceVersion()});
            }
        }
        finally {
            redisLock.unlock();
        }
    }
}

