/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.job.business;

import cn.hutool.core.collection.CollectionUtil;
import com.bizvane.audience.bo.QaProductBO;
import com.bizvane.audience.entity.business.SysDimSkuEntityExample;
import com.bizvane.audience.enums.TableTypeEnum;
import com.bizvane.audience.mapper.business.SysDimSkuEntityMapper;
import com.bizvane.audience.process.job.business.AbstractMetaDataJob;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="productJob")
@Component
public class ProductJob
extends AbstractMetaDataJob {
    private static final String QA_PRODUCT = "qa_t_sys_dim_sku";
    @Autowired
    private SysDimSkuEntityMapper sysDimSkuEntityMapper;

    @Override
    String getBusinessTypeName() {
        return TableTypeEnum.PRODUCT.name();
    }

    @Override
    List<AbstractMetaDataJob.AbstractHandler> handlers() {
        return Arrays.asList(new ProductHandler());
    }

    class ProductHandler
    extends AbstractMetaDataJob.AbstractHandler<QaProductBO> {
        ProductHandler() {
            super(ProductJob.this);
        }

        @Override
        Long readInternal(Long position, List<QaProductBO> data) {
            SysDimSkuEntityExample example = new SysDimSkuEntityExample();
            example.createCriteria().andSysCompanyIdEqualTo(this.getSysCompanyId()).andSysBrandIdEqualTo(this.getSysBrandId()).andValidEqualTo(Boolean.valueOf(true)).andSysDimSkuIdLessThan(position);
            example.setOrderByClause(" sys_dim_sku_id desc limit  ".concat(AbstractMetaDataJob.getStep().toString()));
            List entityList = ProductJob.this.sysDimSkuEntityMapper.selectByExampleWithBlobs(example);
            if (CollectionUtil.isNotEmpty((Collection)entityList)) {
                List orderDetailBos = entityList.stream().map(entity -> {
                    QaProductBO qaProductBo = new QaProductBO();
                    BeanUtils.copyProperties((Object)entity, (Object)qaProductBo);
                    return qaProductBo;
                }).collect(Collectors.toList());
                data.addAll(orderDetailBos);
                return data.get(data.size() - 1).getSysDimSkuId();
            }
            return position;
        }

        @Override
        Boolean supportQaTableType(String qaTableType) {
            if (ProductJob.QA_PRODUCT.equals(qaTableType)) {
                return true;
            }
            return false;
        }

        @Override
        String getBusinessTableName() {
            return ProductJob.QA_PRODUCT;
        }
    }
}

