/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.job.business;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.audience.bo.QaMemberBO;
import com.bizvane.audience.enums.TableTypeEnum;
import com.bizvane.audience.process.job.business.AbstractMetaDataJob;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="memberJob")
@Component
public class MemberJob
extends AbstractMetaDataJob {
    private static final String QA_MEMBER = "qa_t_mbr_members";
    @Autowired
    private RestHighLevelClient client;

    @Override
    String getBusinessTypeName() {
        return TableTypeEnum.MEMBER.name();
    }

    @Override
    List<AbstractMetaDataJob.AbstractHandler> handlers() {
        return Arrays.asList(new MemberHandler());
    }

    class MemberHandler
    extends AbstractMetaDataJob.AbstractElasticSearchHandler<QaMemberBO> {
        MemberHandler() {
            super(MemberJob.this);
        }

        @Override
        Boolean supportQaTableType(String qaTableType) {
            if (MemberJob.QA_MEMBER.equals(qaTableType)) {
                return true;
            }
            return false;
        }

        @Override
        String getBusinessTableName() {
            return MemberJob.QA_MEMBER;
        }

        @Override
        void positionBuilder(Long position, BoolQueryBuilder boolQueryBuilder) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"mbrMemberId").lt((Object)position));
        }

        @Override
        Long search(Long position, List<QaMemberBO> data, BoolQueryBuilder boolQueryBuilder) {
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.from(0);
            sourceBuilder.size(AbstractMetaDataJob.getStep().intValue());
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            sourceBuilder.fetchSource(new String[]{"mbrMemberId", "sysCompanyId", "brandId", "memberCode", "cardNo", "offlineCardNo", "erpId", "name", "gender", "phone", "email", "idCard", "birthday", "province", "city", "county", "address", "headPortraits", "barCode", "openCardTime", "bindCardTime", "generalizeChannel", "openCardChannelId", "openCardGuideId", "openCardStoreId", "serviceStoreId", "serviceGuideId", "wxOpenId", "wxUnionId", "wxPublicId", "levelId", "cardUseStatus", "balance", "petCard", "valid"}, null);
            FieldSortBuilder sb = (FieldSortBuilder)SortBuilders.fieldSort((String)"mbrMemberId").order(SortOrder.DESC);
            sourceBuilder.sort((SortBuilder)sb);
            SearchRequest searchRequest = new SearchRequest(new String[]{"t_mbr_members"});
            searchRequest.types(new String[]{"doc"});
            searchRequest.source(sourceBuilder);
            try {
                SearchResponse response = MemberJob.this.client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                ArrayList qaMemberBos = new ArrayList();
                if (hits.getTotalHits() > 0L) {
                    hits.forEach(searchHitField -> {
                        String source = searchHitField.getSourceAsString();
                        JSONObject jsonObject = JSON.parseObject((String)source);
                        QaMemberBO qaMemberBO = (QaMemberBO)jsonObject.toJavaObject(QaMemberBO.class);
                        qaMemberBos.add(qaMemberBO);
                    });
                    data.addAll(qaMemberBos);
                    return data.get(data.size() - 1).getMbrMemberId();
                }
                return position;
            }
            catch (IOException e) {
                throw new RuntimeException("es\u67e5\u8be2\u5f02\u5e38");
            }
        }
    }
}

