/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.job;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import cn.bizvane.rocketmq.spring.exception.MessageSendException;
import com.aliyuncs.retailadvqa_public.model.v20200515.ListAudiencesResponse;
import com.bizvane.audience.exception.AudienceErrorCode;
import com.bizvane.audience.exception.AudienceException;
import com.bizvane.audience.service.audience.SearchService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="startGetAudienceList")
@Component
public class GetAudienceListJob
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(GetAudienceListJob.class);
    @Autowired
    private SearchService searchService;
    @Resource
    RocketMQTemplate mqTemplate;
    public static final Integer PAGE_NUM = 1;

    public ReturnT<String> execute(String s) {
        List tenantList = this.searchService.getTenantList();
        tenantList.stream().forEach(item -> {
            String tenantId = item.getTenantId();
            ListAudiencesResponse response = this.searchService.getAudienchList(tenantId, PAGE_NUM);
            Integer totalNum = Integer.valueOf(response.getData().getTotalNum());
            Integer pageSize = Integer.valueOf(response.getData().getPageSize());
            Integer totalPage = (totalNum + pageSize - 1) / pageSize;
            List contentItemList = response.getData().getContent();
            if (!contentItemList.isEmpty()) {
                for (int i = 1; i <= totalPage; ++i) {
                    contentItemList = this.searchService.getAudienchList(tenantId, Integer.valueOf(i)).getData().getContent();
                    contentItemList.parallelStream().forEach(qa -> {
                        String serialNumber = this.searchService.audienceListFlow(qa, item);
                        try {
                            log.info("send AUDIENCES_LIST_QUEUE mq message:{}", (Object)qa.toString());
                            Destination destination = new Destination();
                            destination.setTopic("qa_audiences_contentitem_export");
                            destination.setTag(item.getTenantId());
                            this.mqTemplate.send(destination, qa, serialNumber);
                        }
                        catch (MessageSendException e) {
                            throw new AudienceException("GetAudienceListJob send mq error :{}", e.getMessage());
                        }
                        catch (Exception e) {
                            throw new AudienceException(AudienceErrorCode.INSTER_LABEL_GROUP_ERROR, new Object[]{qa.toString(), item.toString()});
                        }
                    });
                }
            } else {
                log.warn("tenantId is not list to contentItemList:{}", (Object)tenantId);
            }
        });
        return ReturnT.SUCCESS;
    }
}

