/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.job.business;

import cn.hutool.core.collection.CollectionUtil;
import com.bizvane.audience.bo.QaOrderBO;
import com.bizvane.audience.bo.QaOrderDetailBO;
import com.bizvane.audience.entity.business.MbrOrderDetailEntityExample;
import com.bizvane.audience.entity.business.MbrOrderEntityExample;
import com.bizvane.audience.enums.TableTypeEnum;
import com.bizvane.audience.mapper.business.MbrOrderDetailEntityMapper;
import com.bizvane.audience.mapper.business.MbrOrderEntityMapper;
import com.bizvane.audience.process.job.business.AbstractMetaDataJob;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="orderJob")
@Component
public class OrderJob
extends AbstractMetaDataJob {
    private static final String QA_ORDER = "qa_t_mbr_order";
    private static final String QA_ORDER_DETAIL = "qa_t_mbr_order_detail";
    @Autowired
    private MbrOrderEntityMapper mbrOrderEntityMapper;
    @Autowired
    private MbrOrderDetailEntityMapper mbrOrderDetailEntityMapper;

    @Override
    String getBusinessTypeName() {
        return TableTypeEnum.ORDER.name();
    }

    @Override
    List<AbstractMetaDataJob.AbstractHandler> handlers() {
        return Arrays.asList(new OrderHandler(), new OrderDetailHandler());
    }

    class OrderDetailHandler
    extends AbstractMetaDataJob.AbstractHandler<QaOrderDetailBO> {
        OrderDetailHandler() {
            super(OrderJob.this);
        }

        @Override
        Long readInternal(Long position, List<QaOrderDetailBO> data) {
            MbrOrderDetailEntityExample example = new MbrOrderDetailEntityExample();
            example.createCriteria().andSysCompanyIdEqualTo(this.getSysCompanyId()).andBrandIdEqualTo(this.getSysBrandId()).andValidEqualTo(Boolean.valueOf(true)).andMbrOrderDetailIdLessThan(position);
            example.setOrderByClause(" mbr_order_detail_id desc limit  ".concat(AbstractMetaDataJob.getStep().toString()));
            List entityList = OrderJob.this.mbrOrderDetailEntityMapper.selectByExample(example);
            if (CollectionUtil.isNotEmpty((Collection)entityList)) {
                List orderDetailBos = entityList.stream().map(entity -> {
                    QaOrderDetailBO qaOrderDetailBo = new QaOrderDetailBO();
                    BeanUtils.copyProperties((Object)entity, (Object)qaOrderDetailBo);
                    return qaOrderDetailBo;
                }).collect(Collectors.toList());
                data.addAll(orderDetailBos);
                return data.get(data.size() - 1).getMbrOrderDetailId();
            }
            return position;
        }

        @Override
        Boolean supportQaTableType(String qaTableType) {
            if (OrderJob.QA_ORDER_DETAIL.equals(qaTableType)) {
                return true;
            }
            return false;
        }

        @Override
        String getBusinessTableName() {
            return OrderJob.QA_ORDER_DETAIL;
        }
    }

    class OrderHandler
    extends AbstractMetaDataJob.AbstractHandler<QaOrderBO> {
        OrderHandler() {
            super(OrderJob.this);
        }

        @Override
        Long readInternal(Long position, List<QaOrderBO> data) {
            MbrOrderEntityExample example = new MbrOrderEntityExample();
            example.createCriteria().andSysCompanyIdEqualTo(this.getSysCompanyId()).andBrandIdEqualTo(Integer.valueOf(this.getSysBrandId().intValue())).andValidEqualTo(Boolean.valueOf(true)).andMbrOrderIdLessThan(position);
            example.setOrderByClause(" mbr_order_id desc limit  ".concat(AbstractMetaDataJob.getStep().toString()));
            List entityList = OrderJob.this.mbrOrderEntityMapper.selectByExample(example);
            if (CollectionUtil.isNotEmpty((Collection)entityList)) {
                List orderBoList = entityList.stream().map(entity -> {
                    QaOrderBO qaOrderBo = new QaOrderBO();
                    BeanUtils.copyProperties((Object)entity, (Object)qaOrderBo);
                    return qaOrderBo;
                }).collect(Collectors.toList());
                data.addAll(orderBoList);
                return data.get(data.size() - 1).getMbrOrderId();
            }
            return position;
        }

        @Override
        Boolean supportQaTableType(String qaTableType) {
            if (OrderJob.QA_ORDER.equals(qaTableType)) {
                return true;
            }
            return false;
        }

        @Override
        String getBusinessTableName() {
            return OrderJob.QA_ORDER;
        }
    }
}

