/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.job.business;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.audience.bo.QaCouponDefinitionBO;
import com.bizvane.audience.bo.QaCouponEntityBO;
import com.bizvane.audience.entity.business.CouponDefinitionEntityExample;
import com.bizvane.audience.enums.TableTypeEnum;
import com.bizvane.audience.mapper.business.CouponDefinitionEntityMapper;
import com.bizvane.audience.process.job.business.AbstractMetaDataJob;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="couponJob")
@Component
public class CouponJob
extends AbstractMetaDataJob {
    private static final String QA_COUPON_DEFINITION = "qa_t_coupon_definition";
    private static final String QA_COUPON_ENTITY = "qa_t_coupon_entity";
    @Autowired
    private CouponDefinitionEntityMapper couponDefinitionEntityMapper;
    @Autowired
    private RestHighLevelClient client;

    @Override
    String getBusinessTypeName() {
        return TableTypeEnum.COUPON.name();
    }

    @Override
    List<AbstractMetaDataJob.AbstractHandler> handlers() {
        return Arrays.asList(new CouponDefinitionHandler(), new CouponEntityHandler());
    }

    class CouponEntityHandler
    extends AbstractMetaDataJob.AbstractElasticSearchHandler<QaCouponEntityBO> {
        CouponEntityHandler() {
            super(CouponJob.this);
        }

        @Override
        protected void commonBuilder(BoolQueryBuilder boolQueryBuilder) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"sysCompanyId", (Object)this.getSysCompanyId()));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"sysBrandId", (Object)this.getSysBrandId()));
        }

        @Override
        Boolean supportQaTableType(String qaTableType) {
            if (CouponJob.QA_COUPON_ENTITY.equals(qaTableType)) {
                return true;
            }
            return false;
        }

        @Override
        String getBusinessTableName() {
            return CouponJob.QA_COUPON_ENTITY;
        }

        @Override
        void positionBuilder(Long position, BoolQueryBuilder boolQueryBuilder) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"couponEntityId").lt((Object)position));
        }

        @Override
        Long search(Long position, List<QaCouponEntityBO> data, BoolQueryBuilder boolQueryBuilder) {
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.from(0);
            sourceBuilder.size(AbstractMetaDataJob.getStep().intValue());
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            sourceBuilder.fetchSource(new String[]{"couponEntityId", "sysCompanyId", "sysBrandId", "couponCode", "couponDefinitionId", "couponBatchSendRecordId", "memberCode", "couponName", "money", "discount", "bindStatus", "validDateStart", "validDateEnd", "isLock", "usePassword", "sendType", "sendBusinessId", "useType", "useStoreId", "useBusinessCode", "useTime", "isUse", "couponStatus", "preferentialType", "useFrom", "useMemberCode"}, null);
            FieldSortBuilder sb = (FieldSortBuilder)SortBuilders.fieldSort((String)"couponEntityId").order(SortOrder.DESC);
            sourceBuilder.sort((SortBuilder)sb);
            SearchRequest searchRequest = new SearchRequest(new String[]{"t_coupon_entity"});
            searchRequest.types(new String[]{"doc"});
            searchRequest.source(sourceBuilder);
            try {
                SearchResponse response = CouponJob.this.client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                ArrayList arrayList = new ArrayList();
                if (hits.getTotalHits() > 0L) {
                    hits.forEach(searchHitField -> {
                        String source = searchHitField.getSourceAsString();
                        JSONObject jsonObject = JSON.parseObject((String)source);
                        QaCouponEntityBO qaCouponEntityBo = (QaCouponEntityBO)jsonObject.toJavaObject(QaCouponEntityBO.class);
                        arrayList.add(qaCouponEntityBo);
                    });
                    data.addAll(arrayList);
                    return data.get(data.size() - 1).getCouponEntityId();
                }
                return position;
            }
            catch (IOException e) {
                throw new RuntimeException("es\u67e5\u8be2\u5f02\u5e38");
            }
        }
    }

    class CouponDefinitionHandler
    extends AbstractMetaDataJob.AbstractHandler<QaCouponDefinitionBO> {
        CouponDefinitionHandler() {
            super(CouponJob.this);
        }

        @Override
        Long readInternal(Long position, List<QaCouponDefinitionBO> data) {
            CouponDefinitionEntityExample example = new CouponDefinitionEntityExample();
            example.createCriteria().andSysCompanyIdEqualTo(this.getSysCompanyId()).andSysBrandIdEqualTo(this.getSysBrandId()).andValidEqualTo(Boolean.valueOf(true)).andCouponDefinitionIdLessThan(position);
            example.setOrderByClause(" coupon_definition_id desc limit  ".concat(AbstractMetaDataJob.getStep().toString()));
            List entityList = CouponJob.this.couponDefinitionEntityMapper.selectByExampleWithBlobs(example);
            if (CollectionUtil.isNotEmpty((Collection)entityList)) {
                List qaCouponDefinitionBos = entityList.stream().map(entity -> {
                    QaCouponDefinitionBO qaCouponDefinitionBO = new QaCouponDefinitionBO();
                    BeanUtils.copyProperties((Object)entity, (Object)qaCouponDefinitionBO);
                    return qaCouponDefinitionBO;
                }).collect(Collectors.toList());
                data.addAll(qaCouponDefinitionBos);
                return data.get(data.size() - 1).getCouponDefinitionId();
            }
            return position;
        }

        @Override
        Boolean supportQaTableType(String qaTableType) {
            if (CouponJob.QA_COUPON_DEFINITION.equals(qaTableType)) {
                return true;
            }
            return false;
        }

        @Override
        String getBusinessTableName() {
            return CouponJob.QA_COUPON_DEFINITION;
        }
    }
}

