/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.job;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.bizvane.audience.common.util.SysResponseEnum;
import com.bizvane.audience.entity.metadata.CompanyTableMappingEntity;
import com.bizvane.audience.entity.metadata.MetadataTableEntity;
import com.bizvane.audience.enums.TableTypeEnum;
import com.bizvane.audience.mapper.metadata.CompanyTableMappingMapper;
import com.bizvane.audience.mapper.metadata.MetadataTableMapper;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@JobHandler(value="memberMetadataJob")
public class MemberMetadataJob
extends IJobHandler {
    private Logger logger = LoggerFactory.getLogger(MemberMetadataJob.class);
    @Autowired
    private MetadataTableMapper metadataTableMapper;
    @Autowired
    private CompanyTableMappingMapper companyTableMappingMapper;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private String redisPrefix = "quickAudience-processor-memberMetadataJob";

    public ReturnT<String> execute(String s) throws Exception {
        this.logger.info("memberMetadataJob begin work ");
        ReturnT returnT = new ReturnT();
        List metadataTableEntityList = this.metadataTableMapper.selectEntityByTableType(TableTypeEnum.MEMBER.name());
        if (CollectionUtil.isEmpty((Collection)metadataTableEntityList)) {
            returnT.setCode(SysResponseEnum.SUCCESS.getCode());
            returnT.setMsg("\u5143\u6570\u636e\u4e3a\u7a7a");
            return returnT;
        }
        for (MetadataTableEntity entity : metadataTableEntityList) {
            List companyTableMappingEntityList = this.companyTableMappingMapper.selectEntityByMetaTable(entity.getId());
            for (CompanyTableMappingEntity mappingEntity : companyTableMappingEntityList) {
            }
        }
        return null;
    }

    private void readMembers(Long sysCompanyId, Long sysBrandId) {
        String membersRedisKey = this.redisPrefix.concat("t_mbr_members").concat(this.nowDate());
        String membersRedisValue = (String)this.stringRedisTemplate.opsForValue().get((Object)membersRedisKey);
        if (StrUtil.isEmpty((CharSequence)membersRedisValue)) {
            // empty if block
        }
    }

    private String nowDate() {
        LocalDate today = LocalDate.now();
        return today.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }
}

