/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.process.job;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import cn.bizvane.rocketmq.spring.exception.MessageSendException;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.retailadvqa_public.client.QATestAcsClient;
import com.aliyuncs.retailadvqa_public.model.v20200515.CheckAudiencesExportStatusRequest;
import com.aliyuncs.retailadvqa_public.model.v20200515.CheckAudiencesExportStatusResponse;
import com.bizvane.audience.common.constant.AudienceStatus;
import com.bizvane.audience.entity.audience.AudienceDownloadEntity;
import com.bizvane.audience.exception.AudienceErrorCode;
import com.bizvane.audience.exception.AudienceException;
import com.bizvane.audience.mapper.audience.AudienceDownloadMapper;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@JobHandler(value="startGetAudienceStatus")
@Component
public class GetAudienceStatusJob
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(GetAudienceStatusJob.class);
    @Resource
    private AudienceDownloadMapper audienceDownloadMapper;
    @Value(value="${aliyun.oss.accessId}")
    private String accessId;
    @Autowired
    RocketMQTemplate mqTemplate;
    public static final String SUCCESS = "success";

    public ReturnT<String> execute(String s) {
        List audienceDownloadEntities = this.audienceDownloadMapper.selectByDataStatus(AudienceStatus.DOWNLOAD_STATUS_ING);
        String tenantId = null;
        String audienceId = null;
        try {
            for (AudienceDownloadEntity audienceDownloadEntity : audienceDownloadEntities) {
                tenantId = audienceDownloadEntity.getTenantId();
                audienceId = audienceDownloadEntity.getAudienceId();
                tenantId = "bea3937b-1ff5-4aab-9a6a-f90514a0f584";
                QATestAcsClient client = new QATestAcsClient();
                CheckAudiencesExportStatusRequest request = new CheckAudiencesExportStatusRequest();
                request.setAccessId(this.accessId);
                request.setAudienceId(audienceId);
                request.setTenantId(tenantId);
                CheckAudiencesExportStatusResponse response = (CheckAudiencesExportStatusResponse)client.getAcsResponse((AcsRequest)request);
                if (!SUCCESS.equals(response.getData())) continue;
                try {
                    log.info("send audiences_status_queue mq message:{}", (Object)audienceId);
                    Destination destination = new Destination();
                    destination.setTopic("qa_audiences_download_audience_id");
                    this.mqTemplate.send(destination, (Object)audienceId);
                }
                catch (MessageSendException e) {
                    log.error("GetAudienceStatusJob send mq error :{}", (Object)e.getMessage());
                }
            }
        }
        catch (ClientException e) {
            throw new AudienceException(AudienceErrorCode.GET_CHECK_AUDIENCESEXPORT_STATUS_ERROR, new Object[]{tenantId});
        }
        return ReturnT.SUCCESS;
    }
}

