/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.models.vo.vg.VGRequestHeaderVo;
import com.bizvane.core.facade.interfaces.CoreTraceFeign;
import com.bizvane.core.facade.models.po.TracePO;
import com.bizvane.core.facade.models.po.TraceRecordPO;
import com.bizvane.core.facade.models.vo.TraceRecordVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OptionUtils {
    private static final Logger log = LoggerFactory.getLogger(OptionUtils.class);
    public static final String SOURCE_ID = "sourceId";
    @Autowired
    private CoreTraceFeign coreTraceFeign;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Resource
    private HttpServletRequest request;

    public VGRequestHeaderVo getRequestHeader(String memberCode) {
        log.info("OptionUtils#getRequestHeader#memberCode:{}", (Object)memberCode);
        String page = this.request.getHeader("page");
        String traceId = this.request.getHeader("sourceid");
        log.info("OptionUtils#getRequestHeader#memberCode:{},page:{},traceId:{}", new Object[]{memberCode, page, traceId});
        VGRequestHeaderVo vgRequestHeaderVo = new VGRequestHeaderVo();
        vgRequestHeaderVo.setPage(page);
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            try {
                Long traceIdLong = Long.valueOf(traceId);
                ResponseData tracePOResponseData = this.coreTraceFeign.selectByTraceId(traceIdLong);
                if (tracePOResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() && tracePOResponseData.getData() != null) {
                    TracePO data = (TracePO)tracePOResponseData.getData();
                    String traceValue = data.getTraceValue();
                    JSONObject jsonObject = (JSONObject)JSON.parseObject((String)traceValue, JSONObject.class);
                    vgRequestHeaderVo.setSourceid(jsonObject.getString(SOURCE_ID));
                }
            }
            catch (Exception e) {
                log.warn("OptionUtils#getRequestHeader#Exception:{}", (Throwable)e);
            }
        } else {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
            TraceRecordVo traceRecordVo = new TraceRecordVo();
            traceRecordVo.setUnionId(member.getWxUnionId());
            traceRecordVo.setSysCompanyId(member.getSysCompanyId());
            ResponseData traceRecordPOResponseData = this.coreTraceFeign.selectTraceRecord(traceRecordVo);
            log.info("OptionUtils#getRequestHeader#traceRecordPOResponseData:{}", (Object)JSON.toJSONString((Object)traceRecordPOResponseData));
            if (traceRecordPOResponseData.getData() != null) {
                String traceValue = ((TraceRecordPO)traceRecordPOResponseData.getData()).getTraceValue();
                JSONObject jsonObject = (JSONObject)JSON.parseObject((String)traceValue, JSONObject.class);
                vgRequestHeaderVo.setSourceid(jsonObject.getString(SOURCE_ID));
            }
        }
        log.info("OptionUtils#getRequestHeader#vgRequestHeaderVo:{}", (Object)JSON.toJSONString((Object)vgRequestHeaderVo));
        return vgRequestHeaderVo;
    }
}

