/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.vg;

import com.bizvane.appletservice.models.vo.vg.VGClubBrandRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGStoreListResponseVO;
import com.bizvane.appletserviceimpl.impl.vg.VGGetAllMemberInfoServiceImpl;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.fitmentservice.consts.AppletModularEnum;
import com.bizvane.fitmentservice.models.Rpc.FitMentServiceRpc;
import com.bizvane.fitmentservice.models.Rpc.MbrCenterPictureRpc;
import com.bizvane.fitmentservice.models.po.AppletResourcesPO;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class VGStoreServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(VGStoreServiceImpl.class);
    @Autowired
    private FitMentServiceRpc fitMentServiceRpc;
    final Long ShopBrandIdTest = 150L;
    final Long ShopBrandIdPrd = 157L;
    @Autowired
    private MbrCenterPictureRpc mbrCenterPictureRpc;
    @Autowired
    private VGGetAllMemberInfoServiceImpl vgGetAllMemberInfoService;

    public ResponseData<List<VGStoreListResponseVO>> getAllClubList(VGClubBrandRequestVo vgClubBrandRequestVo) {
        List brandListByCompanyId = this.vgGetAllMemberInfoService.getBrandListByCompanyId(vgClubBrandRequestVo.getSysCompanyId(), Boolean.TRUE);
        AppletResourcesPO appletResourcesPO = null;
        ArrayList<VGStoreListResponseVO> resultList = new ArrayList<VGStoreListResponseVO>();
        Iterator brandPoListiterator = brandListByCompanyId.iterator();
        while (brandPoListiterator.hasNext()) {
            SysBrandPo po = (SysBrandPo)brandPoListiterator.next();
            if (po.getMainMaster().booleanValue()) {
                brandPoListiterator.remove();
                continue;
            }
            if ("TW-CLUB".equals(po.getBrandCode())) {
                brandPoListiterator.remove();
                continue;
            }
            if (this.ShopBrandIdTest.equals(po.getSysBrandId()) || this.ShopBrandIdPrd.equals(po.getSysBrandId())) {
                brandPoListiterator.remove();
                continue;
            }
            List includeBrandIds = vgClubBrandRequestVo.getIncludeBrandIds();
            if (CollectionUtils.isNotEmpty((Collection)includeBrandIds) && !includeBrandIds.contains(po.getSysBrandId())) {
                brandPoListiterator.remove();
                continue;
            }
            ResponseData listResponseData = this.mbrCenterPictureRpc.showMbrCenterPictures(AppletModularEnum.STORES_NAVIGATION.getModularCode(), po.getSysBrandId());
            appletResourcesPO = ObjectUtils.isEmpty((Object)listResponseData) ? new AppletResourcesPO() : (ObjectUtils.isEmpty((Object)listResponseData.getData()) ? new AppletResourcesPO() : (AppletResourcesPO)((List)listResponseData.getData()).get(0));
            VGStoreListResponseVO result = VGStoreListResponseVO.builder().clubName(po.getBrandName()).brandCode(po.getBrandCode()).brandNick(po.getBrandNick()).imgUrl(appletResourcesPO.getModularContent()).sysBrandId(po.getSysBrandId()).sysCompanyId(po.getSysCompanyId()).build();
            resultList.add(result);
        }
        ResponseData responseData = new ResponseData();
        responseData.setData(resultList);
        return responseData;
    }
}

