/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.vg;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.MemberOpenCardStoreService;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.appletservice.models.po.AppletResourcesPOExample;
import com.bizvane.appletservice.models.vo.MemberOpenCardStoreVo;
import com.bizvane.appletservice.models.vo.vg.VGAlipaySlideImgRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGAlipaySlideImgResponseVo;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMsgAuthRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMsgAuthResponseVo;
import com.bizvane.appletservice.rpc.vg.MemberCenterServiceRpc;
import com.bizvane.appletserviceimpl.impl.vg.WechatAppletSubscribeMsgServiceImpl;
import com.bizvane.appletserviceimpl.mappers.AppletResourcesPOMapper;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"memberCenterServiceRpc"})
public class MemberCenterServiceRpcImpl
implements MemberCenterServiceRpc {
    private static final Logger log = LoggerFactory.getLogger(MemberCenterServiceRpcImpl.class);
    @Resource
    private AppletResourcesPOMapper appletResourcesPoMapper;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private WechatAppletSubscribeMsgServiceImpl wechatAppletSubscribeMsgService;
    @Autowired
    private MemberOpenCardStoreService memberOpenCardStoreService;

    @PostMapping(value={"/getSlideImg"})
    public ResponseData<List<VGAlipaySlideImgResponseVo>> getSlideImg(@RequestBody VGAlipaySlideImgRequestVo vgAlipaySlideImgRequestVo) {
        String brandCode = "JH";
        ResponseData brandPoResponseData = this.brandServiceRpc.getBrand(vgAlipaySlideImgRequestVo.getSysCompanyId(), brandCode);
        if (brandPoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || brandPoResponseData.getData() == null) {
            return this.returnMessage(false, null);
        }
        ArrayList<VGAlipaySlideImgResponseVo> vgAlipaySlideImgResponseVos = null;
        AppletResourcesPOExample appletResourcesPoExample = new AppletResourcesPOExample();
        appletResourcesPoExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andModularCodeEqualTo("M004").andSysBrandIdEqualTo(((SysBrandPo)brandPoResponseData.getData()).getSysBrandId()).andModularTypeEqualTo("2").andIsShareImgEqualTo(Boolean.valueOf(false));
        List resourcesPos = this.appletResourcesPoMapper.selectByExample(appletResourcesPoExample);
        if (CollectionUtils.isNotEmpty((Collection)resourcesPos)) {
            vgAlipaySlideImgResponseVos = new ArrayList<VGAlipaySlideImgResponseVo>();
            for (AppletResourcesPO appletResourcesPo : resourcesPos) {
                appletResourcesPo.setModularContent(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)appletResourcesPo.getModularContent()));
                VGAlipaySlideImgResponseVo vgAlipaySlideImgResponseVo = new VGAlipaySlideImgResponseVo();
                vgAlipaySlideImgResponseVo.setModularContent(appletResourcesPo.getModularContent());
                vgAlipaySlideImgResponseVo.setSort(appletResourcesPo.getSort());
                vgAlipaySlideImgResponseVos.add(vgAlipaySlideImgResponseVo);
            }
        }
        return this.returnMessage(true, vgAlipaySlideImgResponseVos);
    }

    @PostMapping(value={"/queryBrandWechatAppletSubscribeDataRedis"})
    public VGSubscribeMsgAuthResponseVo queryBrandWechatAppletSubscribeDataRedis(@RequestBody VGSubscribeMsgAuthRequestVo subscribeMsgAuthRequestVo) {
        return this.wechatAppletSubscribeMsgService.queryBrandWechatAppletSubscribeDataRedis(subscribeMsgAuthRequestVo);
    }

    private ResponseData returnMessage(boolean isSuccess, Object data) {
        ResponseData responseData = new ResponseData();
        if (isSuccess) {
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData(data);
        } else {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setData(data);
        }
        return responseData;
    }

    @RequestMapping(value={"/searchStoresByRecordId"}, method={RequestMethod.POST})
    public ResponseData searchStoresByRecordId(@RequestBody MemberOpenCardStoreVo memberOpenCardStoreVo) {
        log.info("searchStoresByRecordId memberOpenCardStoreVo:{}", (Object)JSON.toJSONString((Object)memberOpenCardStoreVo));
        ResponseData responseData = new ResponseData();
        if (null == memberOpenCardStoreVo.getMktActivityPrizeRecordId()) {
            responseData.setMessage("\u4e2d\u5956\u8bb0\u5f55ID\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberOpenCardStoreService.searchStoresByRecordIdRpc(memberOpenCardStoreVo);
    }
}

