/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.vg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.models.vo.vg.VGIntegralGoodsCostComputeVo;
import com.bizvane.appletservice.rpc.IntegralCostComputeServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@RequestMapping(value={"/integralCostComputeServiceRpc"})
public class IntegralCostComputeServiceRpcImpl
implements IntegralCostComputeServiceRpc {
    private static final Logger log = LoggerFactory.getLogger(IntegralCostComputeServiceRpcImpl.class);
    private static final String INTEGRAL_GOODS_COST_COMPUTE = "api/integralCost/VGGoodsCompute";
    @Value(value="${wxStore.baseUrl}")
    private String DOMAINNAME;

    @PostMapping(value={"computeIntegralCost"})
    public ResponseData<Integer> computeIntegralCost(@RequestBody VGIntegralGoodsCostComputeVo vo) {
        log.info("IntegralCostComputeServiceRpcImpl#computeIntegralCost#vo:{}", (Object)JSON.toJSONString((Object)vo));
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-Type", "application/json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sysCompanyId", (Object)vo.getSysCompanyId());
        jsonObject.put("computeMonthInterval", (Object)vo.getComputeMonthInterval());
        jsonObject.put("mallCostPercent", (Object)vo.getMallCostPercent());
        jsonObject.put("ttCostPercent", (Object)vo.getTtCostPercent());
        jsonObject.put("tnCostPercent", (Object)vo.getTnCostPercent());
        jsonObject.put("tzCostPercent", (Object)vo.getTzCostPercent());
        jsonObject.put("vgCostPercent", (Object)vo.getVgCostPercent());
        jsonObject.put("yjCostPercent", (Object)vo.getYjCostPercent());
        log.info("IntegralCostComputeServiceRpcImpl#computeIntegralCost#param:{}", (Object)JSON.toJSONString((Object)jsonObject));
        try {
            String response = HttpUtil.post((String)(this.DOMAINNAME + INTEGRAL_GOODS_COST_COMPUTE), (String)jsonObject.toJSONString(), map);
            log.info("IntegralCostComputeServiceRpcImpl#computeIntegralCost#response:{}", (Object)JSON.toJSONString((Object)response));
        }
        catch (IOException e) {
            log.info("IntegralCostComputeServiceRpcImpl#computeIntegralCost#IOException:{}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
            return responseData;
        }
        return responseData;
    }
}

