/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.MemberLotteryService;
import com.bizvane.appletserviceimpl.impl.DataQueryService;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.common.ActivityRuleTypeEnum;
import com.bizvane.mktcenterservice.models.bo.MktActivityPrizeRecordBO;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizePO;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeBO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeRecordDetailBO;
import com.bizvane.mktcenterservice.models.vo.JudgeMemberVO;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityCommonServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityPrizeServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MemberLotteryServiceImpl
implements MemberLotteryService {
    @Autowired
    private ActivityPrizeServiceRpc activityPrizeServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private ActivityCommonServiceRpc activityCommonServiceRpc;
    @Autowired
    private DataQueryService dataQueryService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    public ResponseData<MktActivityPrizeRecordPO> winningRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        return this.record(mktActivityPrizeRecordPO);
    }

    public ResponseData<MktActivityPrizeRecordBO> winningRecordNew(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        return this.recordNew(mktActivityPrizeRecordPO);
    }

    public ResponseData<ActivityPrizeBO> activityRules(String activePriceCode) {
        ResponseData responseData = new ResponseData();
        ActivityPrizeBO rules = this.rules(activePriceCode);
        if (rules == null) {
            responseData.setMessage("\u65e0\u89c4\u5219");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        MktActivityPOWithBLOBs activityPO = rules.getActivityPO();
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)activityPO.getActivityRule());
        return responseData;
    }

    public ResponseData<MktActivityPOWithBLOBs> activityRulesNew(String activePriceCode) {
        MktActivityPOWithBLOBs activityPO;
        ResponseData responseData = new ResponseData();
        ActivityPrizeBO rules = this.rules(activePriceCode);
        if (rules == null) {
            responseData.setMessage("\u65e0\u89c4\u5219");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        if (null != (activityPO = rules.getActivityPO()) && ActivityRuleTypeEnum.IMG_SHOW.getType().equals(activityPO.getActivityRuleType())) {
            activityPO.setActivityRule(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityPO.getActivityRule()));
        }
        if (StringUtils.isNotBlank((CharSequence)activityPO.getShareImg())) {
            activityPO.setShareImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityPO.getShareImg()));
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)activityPO);
        return responseData;
    }

    public ResponseData lotteryDoIng(String activePriceCode, String memberCode, Long sourceId) {
        return this.activityPrizeServiceRpc.executeActivityPrize(activePriceCode, memberCode, sourceId);
    }

    public ResponseData<ActivityPrizeBO> theWayToAcquireIntegral(String activePriceCode) {
        ResponseData responseData = new ResponseData();
        ActivityPrizeBO rules = this.rules(activePriceCode);
        if (rules == null) {
            responseData.setMessage("\u65e0\u79ef\u5206\u83b7\u53d6\u9014\u5f84");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        MktActivityPOWithBLOBs activityPO = rules.getActivityPO();
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)activityPO.getActivityInfo());
        return responseData;
    }

    public ResponseData<ActivityPrizeBO> luckDraw(String activePriceCode, String memberCode) throws ParseException {
        ResponseData responseData = new ResponseData();
        ActivityPrizeBO rules = this.rules(activePriceCode);
        if (rules == null) {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        List prizePOList = rules.getActivityPrizePOList();
        for (MktActivityPrizePO mktActivityPrizePO : prizePOList) {
            if (mktActivityPrizePO.getPrizeType() != 50) continue;
            mktActivityPrizePO.setPrizeName("\u8c22\u8c22\u60e0\u987e");
        }
        Collections.sort(prizePOList, new /* Unavailable Anonymous Inner Class!! */);
        MktActivityPOWithBLOBs activityPOWithBLOBsData = rules.getActivityPO();
        logger.info("activityPOWithBLOBsData:{}", (Object)JSON.toJSONString((Object)activityPOWithBLOBsData));
        if (StringUtils.isNotBlank((CharSequence)activityPOWithBLOBsData.getShareImg())) {
            activityPOWithBLOBsData.setShareImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityPOWithBLOBsData.getShareImg()));
        }
        Integer triesLimit = activityPOWithBLOBsData.getTriesLimit();
        ProbabilityVO probabilityVO = new ProbabilityVO();
        probabilityVO.setMemberCode(memberCode);
        probabilityVO.setTriesLimit(triesLimit);
        probabilityVO.setMktActivityId(activityPOWithBLOBsData.getMktActivityId());
        ResponseData integerResponseData = this.activityPrizeServiceRpc.residueMemberNumber(probabilityVO);
        Map dataMap = (Map)integerResponseData.getData();
        if (dataMap != null) {
            logger.info("integerResponseData={}", integerResponseData.getData());
            activityPOWithBLOBsData.setTriesLimit((Integer)dataMap.get("triesLimit"));
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)rules);
        return responseData;
    }

    public ResponseData<MktActivityPrizeRecordPO> rotation(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        return this.record(mktActivityPrizeRecordPO);
    }

    public ResponseData countIntegral(String memberCode) {
        Integer integer = this.countIntegrals(memberCode);
        logger.info("\u6211\u7684\u79ef\u5206\u4f1a\u5458\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)memberCode));
        ResponseData responseData = new ResponseData();
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)integer);
        return responseData;
    }

    public ResponseData scanningLottery(String memberCode, String activityCode) {
        Long serviceStoreId;
        logger.info("\u626b\u7801\u62bd\u5956\u5165\u53c2={} acode={}", (Object)JSON.toJSONString((Object)memberCode), (Object)JSON.toJSONString((Object)activityCode));
        ResponseData responseData = new ResponseData();
        ResponseData storeId = this.wxAppletApiService.getServiceStoreId(memberCode);
        JudgeMemberVO judgeMemberVO = new JudgeMemberVO();
        judgeMemberVO.setActivityCode(activityCode);
        judgeMemberVO.setMemberCode(memberCode);
        if (storeId != null && (serviceStoreId = (Long)storeId.getData()) != null) {
            Integer integer = new Long(serviceStoreId).intValue();
            judgeMemberVO.setStoreId(integer);
        }
        ResponseData judgeMember = this.activityServiceRpc.judgeMember(judgeMemberVO);
        logger.info("\u626b\u7801\u62bd\u5956\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)judgeMember.getData()));
        if (judgeMember != null) {
            Integer data = (Integer)judgeMember.getData();
            if (data == 100) {
                responseData.setMessage("\u53c2\u6570\u4e0d\u5408\u683c");
                responseData.setCode(100);
            }
            if (data == 101) {
                responseData.setMessage("\u6d3b\u52a8\u5df2\u8fc7\u671f");
                responseData.setCode(0);
                responseData.setData((Object)"101");
            }
            if (data == 102) {
                responseData.setMessage("\u4f1a\u5458\u4e0d\u5728\u8303\u56f4\u5185");
                responseData.setCode(0);
                responseData.setData((Object)"102");
            }
            if (data == 103) {
                responseData.setMessage("\u6d3b\u52a8\u8fd8\u672a\u5f00\u59cb");
                responseData.setCode(0);
                responseData.setData((Object)"103");
            }
            if (data == 0) {
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setData((Object)"0");
            }
        } else {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        logger.info("\u626b\u7801\u62bd\u5956\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)judgeMember.getData()), (Object)JSON.toJSONString((Object)responseData.getMessage()));
        return responseData;
    }

    public void addressLotteryRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        this.activityCommonServiceRpc.addPrizeAddress(mktActivityPrizeRecordPO);
    }

    public ResponseData addressLotteryRecordNew(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        return this.activityCommonServiceRpc.addPrizeAddressNew(mktActivityPrizeRecordPO);
    }

    public ResponseData<ActivityPrizeRecordDetailBO> winningRecordDetail(MktActivityPrizeRecordPO mktActivityPrizeRecordPo) {
        ResponseData recordDetailBOResponseData = new ResponseData();
        ActivityPrizeRecordDetailBO activityPrizeRecordDetailBO = (ActivityPrizeRecordDetailBO)this.activityPrizeServiceRpc.winningRecordDetail(mktActivityPrizeRecordPo).getData();
        if (null != activityPrizeRecordDetailBO && StringUtils.isNotBlank((CharSequence)activityPrizeRecordDetailBO.getImageUrl())) {
            activityPrizeRecordDetailBO.setImageUrl(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)activityPrizeRecordDetailBO.getImageUrl()));
        }
        activityPrizeRecordDetailBO.setPrizeStatus(activityPrizeRecordDetailBO.getEntityPriceStatus());
        recordDetailBOResponseData.setData((Object)activityPrizeRecordDetailBO);
        return recordDetailBOResponseData;
    }

    private ResponseData<MktActivityPrizeRecordPO> record(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        logger.info("\u62bd\u5956\u8bb0\u5f55\u5165\u53c2={}", (Object)JSON.toJSONString((Object)mktActivityPrizeRecordPO));
        ResponseData responseData = new ResponseData();
        List mktActivityPrizeRecordPOList = this.dataQueryService.getPrizeRecordListRpc(mktActivityPrizeRecordPO);
        logger.info("\u62bd\u5956\u8bb0\u5f55\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)mktActivityPrizeRecordPOList));
        List recordPOListSubList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)mktActivityPrizeRecordPOList)) {
            recordPOListSubList = mktActivityPrizeRecordPOList.size() > 30 ? mktActivityPrizeRecordPOList.subList(0, 29) : mktActivityPrizeRecordPOList;
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData(recordPOListSubList);
        return responseData;
    }

    private ResponseData<MktActivityPrizeRecordBO> recordNew(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        logger.info("\u62bd\u5956\u8bb0\u5f55\u5165\u53c2={}", (Object)JSON.toJSONString((Object)mktActivityPrizeRecordPO));
        ResponseData responseData = new ResponseData();
        List mktActivityPrizeRecordBOList = this.dataQueryService.getPrizeRecordListRpcNew(mktActivityPrizeRecordPO);
        logger.info("\u62bd\u5956\u8bb0\u5f55\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)mktActivityPrizeRecordBOList));
        List recordBOListSubList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)mktActivityPrizeRecordBOList)) {
            recordBOListSubList = mktActivityPrizeRecordBOList;
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData(recordBOListSubList);
        return responseData;
    }

    private ActivityPrizeBO rules(String activePriceCode) {
        logger.info("\u62bd\u5956\u8be6\u60c5={}", (Object)JSON.toJSONString((Object)activePriceCode));
        ActivityPrizeBO bo = this.dataQueryService.selectPrizeList(activePriceCode);
        logger.info("\u62bd\u5956\u8be6\u60c5={}", (Object)JSON.toJSONString((Object)bo));
        return bo;
    }

    private Integer countIntegrals(String memberCode) {
        ResponseData countIntegralByMemberCode = this.memberInfoApiService.getCountIntegralByMemberCode(memberCode);
        logger.info("\u79ef\u5206={}", (Object)JSON.toJSONString((Object)countIntegralByMemberCode.getData()));
        return (Integer)countIntegralByMemberCode.getData();
    }
}

