/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.BrandService;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BrandServiceImpl
implements BrandService {
    private static final Logger log = LoggerFactory.getLogger(BrandServiceImpl.class);
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;

    public ResponseData<List<SysBrandPo>> getExcludeMasterCardBrandList(Long sysCompanyId) {
        ResponseData data = new ResponseData();
        String redisKey = "getExcludeMasterCardBrandList:sysCompanyId_" + sysCompanyId;
        String redisValue = this.redisTemplateService.stringGetStringByKey((Object)redisKey) == null ? null : (String)this.redisTemplateService.stringGetStringByKey((Object)redisKey);
        List<Object> sysBrandPoList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)redisValue)) {
            log.info("sysBrandPoList\u4eceRedis\u4e2d\u83b7\u53d6,redisKey={}", (Object)redisKey);
            sysBrandPoList = JacksonUtil.json2List((String)redisValue, SysBrandPo.class);
        }
        if (StringUtils.isBlank((CharSequence)redisValue) || CollectionUtils.isEmpty(sysBrandPoList)) {
            ResponseData resData = this.brandServiceRpc.getCompanyBrands(sysCompanyId);
            log.info("sysBrandPoList\u67e5\u4e2d\u53f0\u4e2d\u83b7\u53d6,\u9884\u653e\u5165Redis\u4e00\u5c0f\u65f6, redisKey={}, resData:{}", (Object)redisKey, (Object)JSONObject.toJSONString((Object)resData));
            if (resData != null && resData.getCode() == SysResponseEnum.SUCCESS.getCode() && !CollectionUtils.isEmpty((Collection)((Collection)resData.getData()))) {
                sysBrandPoList = (List)resData.getData();
                this.redisTemplateService.stringSetValueAndExpireTime((Object)redisKey, (Object)JacksonUtil.bean2Json(sysBrandPoList), 3600000L);
            }
        }
        sysBrandPoList = sysBrandPoList.stream().filter(brand -> brand.getParentId() == null).collect(Collectors.toList());
        data.setMessage(SysResponseEnum.SUCCESS.getMessage());
        data.setCode(SysResponseEnum.SUCCESS.getCode());
        data.setData(sysBrandPoList);
        return data;
    }

    public List<SysBrandPo> getAllBrandList(Long sysBrandId) {
        ResponseData listResponseData;
        ResponseData responseData;
        String sysBrandRedisKey = "getAllBrandList:sysBrandId_" + sysBrandId;
        String sysBrandRedisValue = (String)this.redisTemplateService.stringGetStringByKey((Object)sysBrandRedisKey);
        if (StringUtils.isEmpty((CharSequence)sysBrandRedisValue) && (responseData = this.brandServiceRpc.getBrandByID(sysBrandId)) != null && responseData.getCode() == SysResponseEnum.SUCCESS.getCode() && responseData.getData() != null) {
            sysBrandRedisValue = JSON.toJSONString((Object)responseData.getData());
            this.redisTemplateService.stringSetValueAndExpireTime((Object)sysBrandRedisKey, (Object)sysBrandRedisValue, 3600000L);
        }
        if (StringUtils.isEmpty((CharSequence)sysBrandRedisValue)) {
            return new ArrayList<SysBrandPo>();
        }
        SysBrandPo sysBrandPo = (SysBrandPo)JSON.parseObject((String)sysBrandRedisValue, SysBrandPo.class);
        String sysCompanyRedisKey = "getAllBrandList:sysCompany_" + sysBrandPo.getSysCompanyId();
        String sysCompanyRedisValue = (String)this.redisTemplateService.stringGetStringByKey((Object)sysCompanyRedisKey);
        if (StringUtils.isEmpty((CharSequence)sysCompanyRedisValue) && (listResponseData = this.brandServiceRpc.getBrandListByCompanyId(sysBrandPo.getSysCompanyId())) != null && listResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() && !CollectionUtils.isEmpty((Collection)((Collection)listResponseData.getData()))) {
            sysCompanyRedisValue = JacksonUtil.bean2Json((Object)listResponseData.getData());
            this.redisTemplateService.stringSetValueAndExpireTime((Object)sysCompanyRedisKey, (Object)sysCompanyRedisValue, 3600000L);
        }
        if (StringUtils.isEmpty((CharSequence)sysCompanyRedisValue)) {
            return new ArrayList<SysBrandPo>();
        }
        List brandPoList = JacksonUtil.json2List((String)sysCompanyRedisValue, SysBrandPo.class);
        return brandPoList;
    }

    public SysBrandPo getBrandById(Long sysBrandId) {
        List allBrandList = this.getAllBrandList(sysBrandId);
        if (CollectionUtils.isEmpty((Collection)allBrandList)) {
            return null;
        }
        Map brandPoMap = allBrandList.stream().collect(Collectors.toMap(SysBrandPo::getSysBrandId, Function.identity()));
        SysBrandPo sysBrandPo = (SysBrandPo)brandPoMap.get(sysBrandId);
        return sysBrandPo;
    }
}

