/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.vg;

import cn.hutool.core.io.FileTypeUtil;
import com.bizvane.baseservice.oss.bean.ResultBean;
import com.bizvane.baseservice.oss.dto.OssUploadReqDto;
import com.bizvane.baseservice.oss.remote.OssServiceRemote;
import com.bizvane.baseservice.oss.utils.OssUtils;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.catalina.servlet4preview.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"vg\u4e0a\u4f20\u56fe\u7247\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/vgUploadImg"})
public class VGUploadImgController {
    private static final Logger log = LoggerFactory.getLogger(VGUploadImgController.class);
    @Autowired
    private OssServiceRemote ossServiceRemote;

    @RequestMapping(value={"/uploadImageOss"}, method={RequestMethod.POST})
    public ResponseData uploadImageOss(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        log.info("VGUploadImgController uploadImageOss.");
        ResponseData responseData = new ResponseData();
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        StringBuffer url = new StringBuffer();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        String fileName = "";
        try {
            fileName = "." + FileTypeUtil.getType((InputStream)file.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        url.append(sysCompanyId).append("/").append(sysBrandId).append("img/").append(format.format(new Date())).append("/").append(uuid).append(fileName);
        String urlStr = url.toString();
        if (urlStr.startsWith("/")) {
            urlStr = urlStr.substring(1);
        }
        String base64Content = null;
        try {
            base64Content = OssUtils.getBase64Content((MultipartFile)file, (String)urlStr);
        }
        catch (Exception e) {
            log.info("uploadImageOss error:{}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.OPERATE_FAILED_FILE_UPLOAD_ERROR.getCode());
            responseData.setMessage(e.getMessage());
            return responseData;
        }
        log.info("uploadImageOss base64Content:{}", (Object)base64Content);
        OssUploadReqDto ossUploadReqDto = new OssUploadReqDto();
        ossUploadReqDto.setAccountName("ali");
        ossUploadReqDto.setBase64Content(base64Content);
        ossUploadReqDto.setFileName(urlStr);
        ResultBean stringResultBean = this.ossServiceRemote.uploadFileByBase64(ossUploadReqDto);
        log.info("uploadImageOss stringResultBean:{}", (Object)JacksonUtil.bean2Json((Object)stringResultBean));
        if (stringResultBean.getSuccess().booleanValue()) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)stringResultBean.getResult());
            return responseData;
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage("\u4e0a\u4f20\u5931\u8d25");
        return responseData;
    }
}

