/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.vg;

import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.po.IntegralRechargeRecordPO;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.vg.VGIntegralRechargeRecordApiService;
import com.bizvane.members.facade.vo.vg.VGIntegralRechargeRecordCalculationRequestVO;
import com.bizvane.members.facade.vo.vg.VGIntegralRechargeRecordSearchRequestVO;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import java.math.BigDecimal;
import org.apache.catalina.servlet4preview.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"vg\u4ff1\u4e50\u90e8\u79ef\u5206\u5145\u503c\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/vgIntegralRecharge"})
public class VGIntegralRechargeController {
    private static final Logger log = LoggerFactory.getLogger(VGIntegralRechargeController.class);
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;
    @Autowired
    private VGIntegralRechargeRecordApiService vgIntegralRechargeRecordApiService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    @GetMapping(value={"/calculationAmount"})
    public ResponseData<Integer> calculationAmount(@RequestParam Long sysBrandId, @RequestParam BigDecimal amount, HttpServletRequest request) {
        if (sysBrandId == null) {
            return ResponseUtils.getFailedData((String)"\u5546\u6237id\u4e3a\u7a7a");
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        ResponseData result = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)bizvaneSessionId)) {
            result.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        if (amount == null) {
            result.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u91d1\u989d");
            return result;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        VGIntegralRechargeRecordCalculationRequestVO vgIntegralRechargeRecordCalculationRequestVO = new VGIntegralRechargeRecordCalculationRequestVO();
        vgIntegralRechargeRecordCalculationRequestVO.setMemberCode(memberCode);
        vgIntegralRechargeRecordCalculationRequestVO.setSysBrandId(sysBrandId);
        vgIntegralRechargeRecordCalculationRequestVO.setAmount(amount);
        ResponseData integerResponseData = this.vgIntegralRechargeRecordApiService.calculationAmount(vgIntegralRechargeRecordCalculationRequestVO);
        return integerResponseData;
    }

    @GetMapping(value={"/queryRecordByOrderNo"})
    public ResponseData<IntegralRechargeRecordPO> calculationAmount(@RequestParam String orderNo, HttpServletRequest request) {
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        ResponseData result = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)bizvaneSessionId)) {
            result.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData model = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel data = (MemberInfoModel)model.getData();
        if (data == null) {
            result.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        VGIntegralRechargeRecordSearchRequestVO vgIntegralRechargeRecordSearchRequestVO = new VGIntegralRechargeRecordSearchRequestVO();
        vgIntegralRechargeRecordSearchRequestVO.setOrderNo(orderNo);
        vgIntegralRechargeRecordSearchRequestVO.setSysBrandId(data.getBrandId());
        vgIntegralRechargeRecordSearchRequestVO.setSysCompanyId(data.getSysCompanyId());
        ResponseData integralRechargeRecordPOResponseData = this.vgIntegralRechargeRecordApiService.queryIntegralRechargeRecordByOrderNo(vgIntegralRechargeRecordSearchRequestVO);
        return integralRechargeRecordPOResponseData;
    }
}

