/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.MemberLotteryService;
import com.bizvane.appletserviceimpl.constant.vg.VGAppletRedisKeyPrefixConstant;
import com.bizvane.appletserviceimpl.utils.UUIDUtils;
import com.bizvane.mktcenterservice.models.bo.MktActivityDetailAndPicture;
import com.bizvane.mktcenterservice.models.bo.MktActivityPrizeRecordBO;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeBO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeRecordDetailBO;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityEGServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.ResponseData;
import com.google.common.base.Throwables;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberLottery"}, method={RequestMethod.POST})
public class MemberLotteryController {
    public static final Logger logger = LoggerFactory.getLogger(MemberLotteryController.class);
    @Autowired
    private MemberLotteryService memberLotteryService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private ActivityEGServiceRpc activityEgServiceRpc;
    @Autowired
    private RedissonTemplate redissonTemplate;

    @RequestMapping(value={"/winningRecord"}, method={RequestMethod.POST})
    public ResponseData<MktActivityPrizeRecordPO> winningRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        mktActivityPrizeRecordPo.setMemberCode(memberCode);
        return this.memberLotteryService.winningRecord(mktActivityPrizeRecordPo);
    }

    @RequestMapping(value={"/winningRecordNew"}, method={RequestMethod.POST})
    public ResponseData<MktActivityPrizeRecordBO> winningRecordNew(MktActivityPrizeRecordPO mktActivityPrizeRecordPo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        mktActivityPrizeRecordPo.setMemberCode(memberCode);
        return this.memberLotteryService.winningRecordNew(mktActivityPrizeRecordPo);
    }

    @RequestMapping(value={"/activityRules"}, method={RequestMethod.POST})
    public ResponseData<ActivityPrizeBO> activityRules(String activePriceCode, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.activityRules(activePriceCode);
    }

    @RequestMapping(value={"/activityRulesNew"}, method={RequestMethod.POST})
    public ResponseData<MktActivityPOWithBLOBs> activityRulesNew(String activePriceCode, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.activityRulesNew(activePriceCode);
    }

    @RequestMapping(value={"/rotation"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<MktActivityPrizeRecordPO> rotation(MktActivityPrizeRecordPO mktActivityPrizeRecordPo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.rotation(mktActivityPrizeRecordPo);
    }

    @RequestMapping(value={"/theWayToAcquireIntegral"}, method={RequestMethod.POST})
    public ResponseData<ActivityPrizeBO> theWayToAcquireIntegral(String activePriceCode, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.theWayToAcquireIntegral(activePriceCode);
    }

    @RequestMapping(value={"/lotteryDoIng"}, method={RequestMethod.POST})
    public ResponseData lotteryDoIng(String activePriceCode, Long sourceId, HttpServletRequest request) {
        logger.info("lotteryDoIng#activePriceCode:{}, sourceId:{}", (Object)activePriceCode, (Object)sourceId);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("lotteryDoIng#bizvaneSessionId:{}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            logger.info("lotteryDoIng#bizvaneSessionId is null");
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        logger.info("lotteryDoIng#memberCode:{}", (Object)memberCode);
        String unrepeatableLockKey = VGAppletRedisKeyPrefixConstant.getUnrepeatableLockKey((String[])new String[]{memberCode, activePriceCode});
        try {
            if (!this.redissonTemplate.tryRLock(unrepeatableLockKey, 2L, 5L)) {
                responseData.setMessage("\u62bd\u5956\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u7ed3\u679c");
                responseData.setCode(-101);
                return responseData;
            }
        }
        catch (InterruptedException e) {
            logger.info("redisson try lock fail :{}", (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        if (memberCode == null) {
            logger.info("lotteryDoIng#memberCode is null");
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.lotteryDoIng(activePriceCode, memberCode, sourceId);
    }

    @RequestMapping(value={"/countIntegral"}, method={RequestMethod.POST})
    public ResponseData<ActivityPrizeBO> countIntegral(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.countIntegral(memberCode);
    }

    @RequestMapping(value={"/scanningLottery"}, method={RequestMethod.POST})
    public ResponseData<ActivityPrizeBO> scanningLottery(String activePriceCode, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.scanningLottery(memberCode, activePriceCode);
    }

    @RequestMapping(value={"/luckDraw"}, method={RequestMethod.POST})
    public ResponseData<ActivityPrizeBO> luckDraw(String activePriceCode, HttpServletRequest request) throws ParseException {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            ProbabilityVO probabilityVO = new ProbabilityVO();
            probabilityVO.setActivityCode(activePriceCode);
            MktActivityDetailAndPicture mktActivityDetailAndPicture = (MktActivityDetailAndPicture)this.activityEgServiceRpc.getMktActivityPOWithBLOBs(probabilityVO).getData();
            String uuid = UUIDUtils.getUUID();
            JSONObject jsonObject1 = new JSONObject();
            jsonObject1.put("activityType", (Object)mktActivityDetailAndPicture.getActivityType());
            jsonObject1.put("uuid", (Object)uuid);
            jsonObject1.put("mktTraceId", (Object)mktActivityDetailAndPicture.getMktTraceId());
            responseData.setData((Object)jsonObject1);
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.luckDraw(activePriceCode, memberCode);
    }

    @RequestMapping(value={"/addressLotteryRecord"}, method={RequestMethod.POST})
    public ResponseData addressLotteryRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        this.memberLotteryService.addressLotteryRecord(mktActivityPrizeRecordPo);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/addressLotteryRecordNew"}, method={RequestMethod.POST})
    public ResponseData addressLotteryRecordNew(MktActivityPrizeRecordPO mktActivityPrizeRecordPo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.addressLotteryRecordNew(mktActivityPrizeRecordPo);
    }

    @RequestMapping(value={"/winningRecordDetail"}, method={RequestMethod.POST})
    public ResponseData<ActivityPrizeRecordDetailBO> winningRecordDetail(MktActivityPrizeRecordPO mktActivityPrizeRecordPo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        mktActivityPrizeRecordPo.setMemberCode(memberCode);
        return this.memberLotteryService.winningRecordDetail(mktActivityPrizeRecordPo);
    }
}

