/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.appletserviceimpl.vo.ResGiftCardPageVo;
import com.bizvane.core.facade.interfaces.CoreTraceFeign;
import com.bizvane.core.facade.models.po.TracePO;
import com.bizvane.serviceCard.interfaces.GiftCardDefStandardServiceFeign;
import com.bizvane.serviceCard.interfaces.GiftCardStandardServiceFeign;
import com.bizvane.serviceCard.models.dto.giftCard.ReqGiftCardDTO;
import com.bizvane.serviceCard.models.dto.giftCard.ReqGiftCardInfoDTO;
import com.bizvane.serviceCard.models.dto.giftCard.ReqGiftCardMemberDTO;
import com.bizvane.serviceCard.models.dto.giftCard.ReqGiftCardReceiveDTO;
import com.bizvane.serviceCard.models.dto.giftCard.ReqGiftCardTransferDTO;
import com.bizvane.serviceCard.models.dto.giftCard.ReqStorageGiftDTO;
import com.bizvane.serviceCard.models.dto.giftCard.ReqTransfer2StorageDTO;
import com.bizvane.serviceCard.models.dto.giftCard.ResGiftCardInfoDTO;
import com.bizvane.serviceCard.models.dto.giftCard.ResGiftCardListDTO;
import com.bizvane.serviceCard.models.dto.giftCard.ResGiftCardPurchaseHisDTO;
import com.bizvane.serviceCard.models.dto.giftCard.ResGiftCardReceiveDTO;
import com.bizvane.serviceCard.models.dto.giftCard.ResGiftCardTransferDTO;
import com.bizvane.serviceCard.models.dto.giftCard.ResGiftCardTransferRecordDTO;
import com.bizvane.serviceCard.models.dto.giftCard.RespTransfer2StorageDTO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u793c\u54c1\u5361"})
@RequestMapping(value={"/giftCard"})
@RestController
@Validated
public class GiftCardController {
    private static final Logger log = LoggerFactory.getLogger(GiftCardController.class);
    @Autowired
    private GiftCardStandardServiceFeign giftCardServiceFeign;
    @Autowired
    private GiftCardDefStandardServiceFeign giftCardDefStandardServiceFeign;
    @Autowired
    private CoreTraceFeign coreTraceFeign;

    @ApiOperation(value="\u6211\u7684\u793c\u54c1\u5361\u5217\u8868")
    @PostMapping(value={"/getMyGiftCard"})
    ResponseData<Page<ResGiftCardListDTO>> getMyGiftCard(@RequestBody @Validated ReqGiftCardDTO vo) {
        log.info("GiftCardController getMyGiftCard params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.giftCardServiceFeign.getMyGiftCard(vo);
    }

    @PostMapping(value={"/transfer"})
    public ResponseData<ResGiftCardTransferDTO> transfer(@RequestBody @Validated ReqGiftCardTransferDTO vo) {
        log.info("GiftCardController transfer params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.giftCardServiceFeign.transfer(vo);
    }

    @PostMapping(value={"/transferSaveTraceAgain"})
    public ResponseData<Long> transferSaveTraceAgain(@RequestBody @Validated ReqGiftCardTransferDTO vo) {
        log.info("GiftCardController transferSaveTraceAgain params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        TracePO tracePo = new TracePO();
        String traceValue = "{\"source_way\":\"appletMbrGiftCard\",\"channel\":\"1\",\"sub_channel\":\"2\",\"memberCode\":\"" + vo.getMemberCode() + "\"}";
        tracePo.setCreateDate(new Date());
        tracePo.setSysCompanyId(vo.getSysCompanyId());
        tracePo.setBrandId(vo.getSysBrandId());
        tracePo.setTraceValue(traceValue);
        return this.coreTraceFeign.insertTrace(tracePo);
    }

    @PostMapping(value={"/getReceiveTransfer"})
    public ResponseData<ResGiftCardReceiveDTO> getReceiveTransfer(@RequestParam(value="transferRecordId") @NotNull Long transferRecordId) {
        log.info("GiftCardController getReceiveTransfer params:{}", (Object)transferRecordId);
        return this.giftCardServiceFeign.getReceiveTransfer(transferRecordId);
    }

    @PostMapping(value={"/receiveTransfer"})
    public ResponseData receiveTransfer(@RequestBody @Validated ReqGiftCardReceiveDTO vo) {
        log.info("GiftCardController receiveTransfer params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.giftCardServiceFeign.receiveTransfer(vo);
    }

    @PostMapping(value={"/getGiftCardInfo"})
    public ResponseData<ResGiftCardInfoDTO> getGiftCardInfo(@RequestBody @Validated ReqGiftCardInfoDTO vo) {
        log.info("GiftCardController getGiftCardInfo params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.giftCardServiceFeign.getGiftCardInfo(vo);
    }

    @PostMapping(value={"/getGiftCardPurchaseHistory"})
    public ResponseData<Page<ResGiftCardPurchaseHisDTO>> getGiftCardPurchaseHistory(@RequestBody @Validated ReqGiftCardMemberDTO vo) {
        log.info("GiftCardController getGiftCardPurchaseHistory params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.giftCardServiceFeign.getGiftCardPurchaseHistory(vo);
    }

    @PostMapping(value={"/getGiftCardTransferRecord"})
    public ResponseData<Page<ResGiftCardTransferRecordDTO>> getGiftCardTransferRecord(@RequestBody @Validated ReqGiftCardMemberDTO vo) {
        log.info("GiftCardController getGiftCardTransferRecord params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.giftCardServiceFeign.getGiftCardTransferRecord(vo);
    }

    @PostMapping(value={"/cancelTransfer"})
    public ResponseData cancelTransfer(@RequestBody @Validated ReqGiftCardInfoDTO vo) {
        log.info("GiftCardController cancelTransfer params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.giftCardServiceFeign.cancelTransfer(vo);
    }

    @PostMapping(value={"/storageGift"})
    public ResponseData<String> storageGift(@RequestBody @Validated ReqStorageGiftDTO dto) {
        log.info("GiftCardController storageGift params:{}", (Object)JacksonUtil.bean2Json((Object)dto));
        return this.giftCardServiceFeign.storageGift(dto);
    }

    @PostMapping(value={"/transfer2Storage"})
    public ResponseData<RespTransfer2StorageDTO> transfer2Storage(@RequestBody @Validated ReqTransfer2StorageDTO dto) {
        log.info("GiftCardController transfer2Storage params:{}", (Object)JacksonUtil.bean2Json((Object)dto));
        return this.giftCardServiceFeign.transfer2Storage(dto);
    }

    @RequestMapping(value={"/serviceCardCanBuyList"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseData<Page<ResGiftCardPageVo>> serviceCardCanBuyList(String sysCompanyId, String sysBrandId, Integer pageNum, Integer pageSize) {
        ResponseData result = new ResponseData();
        Page page = new Page();
        page.setRecords(new ArrayList());
        page.setTotal(0L);
        ResponseData res = this.giftCardDefStandardServiceFeign.getOpenToBuyGiftCardList(sysCompanyId, sysBrandId, pageNum, pageSize);
        if (res.getCode() != 0 || res.getData() == null) {
            result.setCode(-1);
            result.setData((Object)page);
            result.setMessage(res.getMessage());
            return result;
        }
        if (CollectionUtils.isNotEmpty((Collection)((Page)res.getData()).getRecords())) {
            List collect = ((Page)res.getData()).getRecords().stream().map(e -> {
                ResGiftCardPageVo vo = new ResGiftCardPageVo();
                BeanUtils.copyProperties((Object)e, (Object)vo);
                return vo;
            }).collect(Collectors.toList());
            page.setRecords(collect);
            page.setTotal(((Page)res.getData()).getTotal());
        }
        result.setData((Object)page);
        result.setCode(0);
        return result;
    }

    @RequestMapping(value={"/getGiftCardById"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseData<ResGiftCardPageVo> getGiftCardById(@RequestParam(value="giftCardId") @NotBlank(message="giftCardId\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="giftCardId\u4e0d\u80fd\u4e3a\u7a7a") String giftCardId) {
        ResponseData result = new ResponseData();
        ResponseData res = this.giftCardServiceFeign.getGiftCardById(giftCardId);
        if (result.getCode() != 0) {
            result.setCode(-1);
            result.setMessage(res.getMessage());
            return result;
        }
        ResGiftCardPageVo vo = new ResGiftCardPageVo();
        BeanUtils.copyProperties((Object)res.getData(), (Object)vo);
        result.setCode(0);
        result.setData((Object)vo);
        return result;
    }
}

