package com.bizvane.appletservice.rpc;

import com.bizvane.appletservice.models.bo.ObtainGraphicBo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author gs
 */
@FeignClient(value = "${feign.client.applet.name}", path = "${feign.client.applet.path}/graphicTemplateServiceRpc")
public interface GraphicTemplateServiceRpc {
    /**
     * 查询相对的图文模板
     *
     * @param
     * @return
     */
    @RequestMapping("/obtainGraphicTemplate")
    ResponseData<ObtainGraphicBo> obtainGraphicTemplate(@RequestBody ObtainGraphicBo obtainGraphicBo);

    @PostMapping("/groupSending")
    ResponseData groupSending(@RequestBody ObtainGraphicBo obtainGraphicBo);

    @RequestMapping("/groupSendingDoing")
    ResponseData groupSendingDoing(@RequestParam("msgId") String msgId, @RequestParam("brandId") Long brandId);

    @RequestMapping("/groupSendDelete")
    ResponseData groupSendDelete(@RequestParam("msgId") String msgId, @RequestParam("brandId") Long brandId);
}
