/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletservice.utils;

import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;

public class GuavaUtils {
    public static String cacheBrandKey = "applet:cache_brand_info_key:";
    public static String cacheMemberKey = "applet:cache_member_info_key:";
    public static Cache<String, SysBrandPo> cacheBrandInfo = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(20L, TimeUnit.MINUTES).build();
    public static Cache<String, MemberInfoModel> cacheMemberInfo = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(2L, TimeUnit.MINUTES).build();

    public static SysBrandPo getBrandInfo(Long sysBrandId) {
        return (SysBrandPo)cacheBrandInfo.getIfPresent((Object)(cacheBrandKey + sysBrandId));
    }

    public static MemberInfoModel getMemberInfo(String memberCode) {
        return (MemberInfoModel)cacheMemberInfo.getIfPresent((Object)(cacheMemberKey + memberCode));
    }
}

