package com.bizvane.appletservice.interfaces.mktp;

import com.bizvane.mktcenterservice.models.vo.mktp.*;
import com.bizvane.utils.responseinfo.ResponseData;

/**
 * @author yuantq
 * @date 2023/6/28
 */
public interface FissionActivityService {

    /**
     * 获取活动详情
     * @param paramsVO
     * @return
     */
    ResponseData<FissionActivityDetailResponseVO> selectActivityDetail(FissionActivityParamsVO paramsVO);

    /**
     * 立即邀请活动
     * @param paramsVO
     * @return
     */
    ResponseData<FissionActivityInviteResponseVO> inviteNow(FissionActivityParamsVO paramsVO);

    /**
     * 立即邀请活动(客户裂变活动)
     * @param paramsVO
     * @return
     */
    ResponseData<FissionActivityInviteResponseVO> customerActivityInviteNow(FissionActivityParamsVO paramsVO);

    /**
     * 获取活动规则
     * @param paramsVO
     * @return
     */
    ResponseData<ActivityRuleResponseVO> getActivityRuleByCode(FissionActivityParamsVO paramsVO);

    /**
     * 获取邀请记录
     * @param paramsVO
     * @return
     */
    ResponseData<FissionActivityInviteRecordVO> getInvitationRecord(FissionActivityParamsVO paramsVO);

    /**
     * 领奖
     * @param paramsVO
     * @return
     */
    ResponseData<ReceiveAwardResponseVO> receiveAward(FissionActivityParamsVO paramsVO);

    /**
     * 获取员工活码二维码
     * @param staffLiveCodeId
     * @return
     */
    ResponseData<LifeCodeResponseVO> getLiveCodeInfoById(Long staffLiveCodeId);
}
