package com.bizvane.appletservice.utils;

import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import java.util.concurrent.TimeUnit;

public class GuavaUtils {
        public static String cacheBrandKey="applet:cache_brand_info_key:";
        public static String cacheMemberKey="applet:cache_member_info_key:";

        /**
         * 缓存品牌
         */


        public static Cache<String, SysBrandPo> cacheBrandInfo = CacheBuilder.newBuilder()
                .maximumSize(1000)
                .expireAfterWrite(20, TimeUnit.MINUTES)
                .build();

        public static SysBrandPo getBrandInfo(Long sysBrandId){
                return cacheBrandInfo.getIfPresent(cacheBrandKey+sysBrandId);
        }

        /**
         * 缓存会员信息
         */
        public static Cache<String,MemberInfoModel> cacheMemberInfo = CacheBuilder.newBuilder()
                .maximumSize(10000)
                .expireAfterWrite(2, TimeUnit.MINUTES)
                .build();

        public static MemberInfoModel getMemberInfo(String  memberCode){
                return cacheMemberInfo.getIfPresent(cacheMemberKey+memberCode);
        }




}
