package com.bizvane.appletservice.models.vo.integralactivity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @Description: 积分商城获取活动优惠券入参
 * @Since: 2021/10/28
 * @Author: Ngp
 * @Version: 0.1
 */
@Data
public class IntegralNSActivityFindCouponsRequestVO {
    @ApiModelProperty(name = "",value = "",notes = "页数")
    @NotNull(message = "页数不能为空")
    private Integer pageSize;
    @ApiModelProperty(name = "",value = "",notes = "页码")
    @NotNull(message = "页码不能为空")
    private Integer pageIndex;
    @ApiModelProperty(name = "",value = "",notes = "活动id")
    @NotNull(message = "活动id不能为空")
    private Long activityId;
    @ApiModelProperty(name = "",value = "",notes = "企业id")
    @NotNull(message = "企业id不能为空")
    private Long brandId;
    @ApiModelProperty(name = "",value = "",notes = "支付类型")
    private Integer exchangePriceType;
    @ApiModelProperty(name = "",value = "",notes = "会员唯一标志")
    private String memberCode;
}
