package com.bizvane.appletservice.models.vo;

import lombok.Data;

import java.util.Date;
@Data
public class OdersAjhVo {


    /**
     * 订单id
     */
    private Integer id;

    /**
     * 订单状态(1、待派工,2、已取消,3、已完成待评价,4、已完成已评价,5、待审核,6.待上传,7.安装中,8.二次上门,9,未完成,10.申请失败,11.二次配送,12.待维修/待保养

     */
    private Byte ostatus;

    /**
     * 订单编号
     */
    private String number;

    /**
     * 订单类型(1.维修单、2.保养单、3.安装单)
     */
    private Byte orderType;

    /**
     * 下单时间
     */
    private Date orderTime;

    /**
     * 订单更新时间
     */
    private Date updateTime;

    /**
     * 师傅id(外键)
     */
    private Integer masterId;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 预约时间
     */
    private Date appointmentTime;

    /**
     * 提交时间
     */
    private Date submissionTime;

    /**
     * 配送时间
     */
    private Date deliveryTime;

    /**
     * 用户确认配送时间
     */
    private Date confirmDeliveryTime;

    /**
     * 订单关联导购
     */
    private String orderGuide;

    /**
     * 订单回执
     */
    private String orderReceipt;

    /**
     * 相关图片
     */
    private String images;

    /**
     * 取消说明
     */
    private String cancelDescription;

    /**
     * 申请失败说明
     */
    private String failureDescription;

    /**
     * 发货状态(1、未发货,2、已发货)
     */
    private Byte shipmentStatus;

    /**
     * 所属企业id
     */
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    private Long brandId;

    /**
     * 用户姓名
     */
    private String uname;

    /**
     * 用户电话
     */
    private String userPhone;

    /**
     * 用户地址
     */
    private String address;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品规格
     */
    private String cptions;

    /**
     * 分配师傅的时间
     */
    private Date assignMasterTime;

    /**
     * 申请失败原因为其他（1.信息不全,2.缺件,3.不在售后范围）
     */
    private String applicationFailedOthers;

    /**
     * 取消原因为非其他（1.不需要服务了）
     */
    private Byte cancelNonOther;

    /**
     * 其他项目
     */
    private String otherItems;

    /**
     * 店铺id
     */
    private Integer storeId;

    /**
     * 群组id
     */
    private Integer groupId;

    /**
     * 店铺名称
     */
    private String storeName;

}
